<?php

namespace GameCMS\Repositories;

use GameCMS\Models\Server;

class ServerRepository
{
    public static function getById($id): ?Server
    {
        $STH = pdo()->prepare('SELECT * FROM servers WHERE id=:id LIMIT 1');
        $STH->execute([':id' => $id]);
        $server = $STH->fetchObject(Server::class);

        return $server && $server->id ? $server : null;
    }

    public static function getFirstByTrim(): ?Server
    {
        $STH = pdo()->query('SELECT * FROM servers ORDER BY trim LIMIT 1');
        $server = $STH->fetchObject(Server::class);

        return $server && $server->id ? $server : null;
    }

    public static function getByAdminId($adminId): ?Server
    {
        $STH = pdo()->prepare(
            'SELECT 
						servers.*
					FROM 
						servers LEFT JOIN admins ON admins.server = servers.id 
					WHERE admins.id=:admin_id LIMIT 1'
        );
        $STH->execute([':admin_id' => $adminId]);
        $server = $STH->fetchObject(Server::class);

        return $server && $server->id ? $server : null;
    }

    /**
     * @return Server[]
     */
    public static function getAll(): array
    {
        return pdo()->query('SELECT * FROM servers ORDER BY trim')->fetchAll(\PDO::FETCH_CLASS, Server::class);
    }

    /**
     * @param mixed $where
     *
     * @return Server[]
     */
    public static function getForCategories($where = ''): array
    {
        if (!empty($where)) {
            $where = " WHERE {$where} ";
        }

        return pdo()
            ->query("SELECT id, name FROM servers {$where} ORDER BY trim")
            ->fetchAll(\PDO::FETCH_OBJ);
    }

    public static function isExists($id): bool
    {
        $STH = pdo()->prepare('SELECT id FROM servers WHERE id=:id LIMIT 1');
        $STH->execute([':id' => $id]);

        if (empty($STH->fetchObject())) {
            return false;
        }

        return true;
    }
}
