<?php

namespace GameCMS\Services;

use GameCMS\Integrations\Integrations;
use GameCMS\Integrations\Mutes\BlankIntegration;
use GameCMS\Integrations\Mutes\GameCMSIntegration;
use GameCMS\Integrations\Mutes\IksIntegration;
use GameCMS\Integrations\Mutes\MuteSystemIntegration;
use GameCMS\Integrations\Mutes\SourceBansIntegration;

class MutesService
{
    public function getIntegrator(int $integration): ?MuteSystemIntegration
    {
        switch ($integration) {
            case Integrations::USERS_FILE:
            case Integrations::AMXBANS_WITH_USERS_FILE:
            case Integrations::AMXBANS:
            case Integrations::AMXBANS_WITH_GAMECMS_API:
                return new GameCMSIntegration();

            case Integrations::SOURCEBANS:
                return new SourceBansIntegration();

            case Integrations::IKS:
                return new IksIntegration();

            case Integrations::BLANK:
            default:
                return new BlankIntegration();
        }
    }
}
