<?php

class AjaxResponse
{
    public const HTML_RESPONSE = 'html';
    public const JSON_RESPONSE = 'json';

    private $responseType = self::JSON_RESPONSE;
    private $errors = [];
    private $data;
    private $alert;
    private $status = true;

    public function html()
    {
        $this->responseType = self::HTML_RESPONSE;

        return $this;
    }

    public function json()
    {
        $this->responseType = self::JSON_RESPONSE;

        return $this;
    }

    public function error($input, $message)
    {
        $this->errors[$input] = $message;
        $this->status = false;

        return $this;
    }

    public function status($status)
    {
        $this->status = $status;

        return $this;
    }

    public function data($data)
    {
        $this->data = $data;

        return $this;
    }

    public function alert($message)
    {
        $this->alert = $message;

        return $this;
    }

    public function send()
    {
        if (self::JSON_RESPONSE == $this->responseType) {
            $answer = [];
        } else {
            $answer = '';
        }

        if (!$this->status) {
            http_response_code(400);
        }

        if (!empty($this->alert)) {
            if (self::JSON_RESPONSE == $this->responseType) {
                $answer['alert'] = $this->alert;
            } else {
                $answer .= 'Внимание! '.$this->alert.'<br>';
            }
        }

        if (!empty($this->errors)) {
            if (self::JSON_RESPONSE == $this->responseType) {
                $answer['errors'] = $this->errors;
            } else {
                foreach ($this->errors as $input => $message) {
                    $answer .= 'Ошибка в поле '.$input.': «'.$message.'» <br>';
                }
            }
        }

        if (!empty($this->data)) {
            if (self::JSON_RESPONSE == $this->responseType) {
                $answer['data'] = $this->data;
            } else {
                $answer .= $this->data;
            }
        }

        if (self::JSON_RESPONSE == $this->responseType) {
            exit(json_encode($answer));
        }

        exit($answer);
    }
}
