<?php

class AuthApi
{
    public function auth_api_info($pdo)
    {
        $STH = $pdo->query('SELECT `vk_api`, `vk_id`, `vk_key`, `vk_service_key`, `steam_api`, `steam_key`, `fb_api`, `fb_id`, `fb_key` FROM `config__secondary` LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);

        return $STH->fetch();
    }

    public function generate_login_str($pdo, $login)
    {
        $i = 0;
        $user = $login;
        do {
            if (0 != $i) {
                $user = $login.'('.$i.')';
            }
            $STH = $pdo->prepare('SELECT `id` FROM `users` WHERE `login`=:login LIMIT 1');
            $STH->setFetchMode(PDO::FETCH_OBJ);
            $STH->execute([':login' => $user]);
            $row = $STH->fetch();
            if (isset($row->id)) {
                $temp = null;
            } else {
                $temp = 1;
            }
            ++$i;
        } while (empty($temp));

        return $user;
    }

    public function redirect_fix($type)
    {
        if (!isset($_SESSION['reg_session_'.$type])) {
            $_SESSION['reg_session_'.$type] = 1;
        }
        if (3 == $_SESSION['reg_session_'.$type]) {
            unset($_SESSION['reg_session_'.$type]);
            header('Location: ../');

            exit;
        }
        ++$_SESSION['reg_session_'.$type];
    }

    public function redirect_page($pdo)
    {
        $pages = [];
        $STH = $pdo->query("SELECT `url`, `name` FROM `pages` WHERE `name`='main' OR `name`='settings'");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        while ($row = $STH->fetch()) {
            $pages[$row->name] = $row->url;
        }

        return $pages;
    }

    public function setAttachCache($pdo)
    {
        $STH = $pdo->prepare('SELECT password FROM users WHERE id=:id LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':id' => $_SESSION['id']]);
        $row = $STH->fetch();

        $_SESSION['attachCache'] = md5($_SESSION['id'].$row->password);
    }

    public function isAttachCacheCorrect($password)
    {
        if (isset($_SESSION['attachCache']) && ($_SESSION['attachCache'] == md5($_SESSION['id'].$password))) {
            return true;
        }

        return false;
    }
}
