<?php

class FtpConnection
{
    public static function connection($host, $port, $login, $pass, $title)
    {
        $connection = ftp_connect($host, $port);
        if (!$connection) {
            log_error($title.': Не удалось подключиться к FTP серверу '.$host.':'.$port);

            return false;
        }

        $login = ftp_login($connection, $login, $pass);
        if (!$login) {
            log_error($title.': Не удалось авторизоваться на FTP сервере '.$host.':'.$port);

            return false;
        }

        ftp_pasv($connection, true);

        return $connection;
    }

    public static function close($connection)
    {
        ftp_close($connection);
    }

    public static function isFileExists($connection, $path): bool
    {
        $parse = FtpConnection::parsePath($path);

        $file = $parse['file'];
        $dir = $parse['dir'];

        $files = ftp_nlist($connection, $dir);
        for ($i = 0; $i <= count($files); ++$i) {
            if (
                isset($files[$i])
                && (($files[$i] == $dir.$file) || ($files[$i] == $dir.'/'.$file) || ($files[$i] == $file))
            ) {
                return true;
            }
        }

        return false;
    }

    public static function isValidPath($path): bool
    {
        $parse = FtpConnection::parsePath($path);

        if ('' == $parse['file'] || '' == $parse['dir']) {
            return false;
        }

        return true;
    }

    private static function parsePath($path): array
    {
        preg_match('~(.+/)~ui', $path, $parse);
        if (isset($parse[1])) {
            $result['dir'] = $parse[1];
        } else {
            $result['dir'] = '';
        }

        $parse = explode('/', $path);
        if ($parse[count($parse) - 1]) {
            $result['file'] = $parse[count($parse) - 1];
        } else {
            $result['file'] = '';
        }

        return $result;
    }
}
