<?php

use GameCMS\Integrations\Integrations;
use GameCMS\Repositories\ServerRepository;
use GameCMS\Services\AdminsService;
use GameCMS\Services\BansService;
use GameCMS\Services\MutesService;
use GameCMS\Services\StatisticsService;

class GetData
{
    private $tpl;

    public function __construct($_ = null, $tpl = null)
    {
        if (isset($tpl)) {
            $this->tpl = $tpl;
        }
    }

    public function get_gamer_profile($nick, $steam_id = '', $user_id = 0)
    {
        $nick_original = $nick;

        $row = null;
        $nick = check($nick);
        $nick = str_replace(['/', '\\'], '', $nick);

        if ($user_id) {
            $STH = pdo()->prepare('SELECT id, login, avatar, rights FROM users WHERE id=:id LIMIT 1');
            $STH->execute([':id' => $user_id]);
            $row = $STH->fetchObject();
        }

        if (!$row) {
            $STH = pdo()->prepare(
                'SELECT 
						admins.name,
						users.id, 
					    users.login, 
					    users.avatar, 
					    users.rights 
					FROM admins 
						INNER JOIN users ON admins.user_id = users.id 
					WHERE admins.name=:nick OR admins.name=:steam_id 
					LIMIT 1'
            );
            $STH->execute([':nick' => $nick, ':steam_id' => $steam_id]);
            $row = $STH->fetchObject();
        }

        if (!$row) {
            if (!$steam_id) {
                $STH = pdo()->prepare('SELECT id, login, avatar, rights FROM users WHERE nick=:nick LIMIT 1');
                $STH->execute([':nick' => $nick]);
                $row = $STH->fetchObject();
            } else {
                $STH = pdo()->prepare('SELECT id, login, avatar, rights FROM users WHERE steam_id=:steam_id LIMIT 1');
                $STH->execute([':steam_id' => $steam_id]);
                $row = $STH->fetchObject();
            }
        }

        if ($row) {
            return $this->renderProfile(
                $row->id,
                $nick ? clean($nick_original) : $row->login,
                $row->avatar,
                users_groups()[$row->rights]['name'],
                users_groups()[$row->rights]['color']
            );
        }

        return '';
    }

    public function banlist($start, $serverId, $limit = 30, $name = null)
    {
        $start = clean($start, 'int');
        $serverId = check($serverId, 'int');
        $name = check($name);

        global $messages;

        if (empty($serverId)) {
            return tableRowError('Не удалось загрузить данные');
        }

        $prices = pdo()->query('SELECT * FROM config__prices')->fetchObject();

        $server = ServerRepository::getById($serverId);
        if (empty($server)) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $steamIdOperations = new SteamIDOperations();
        $bansService = new BansService();
        $integrator = $bansService->getIntegrator($server->type);
        if ($integrator->isBlank()) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        [$connection, $error] = $integrator->getStorageConnection($server);
        if ($error) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $address = "{$server->ip}:{$server->port}";

        if (empty($name)) {
            if (
                Integrations::AMXBANS == $server->type
                || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
                || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
            ) {
                $table = set_prefix($server->db_prefix, 'bans');
                $STH = $connection->query(
                    "SELECT 
						0 as admin_user_id,
						{$table}.* 
					FROM {$table} 
					WHERE server_ip = '{$address}' 
					ORDER BY bid DESC 
					LIMIT {$start}, {$limit}"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
            }

            if (Integrations::SOURCEBANS == $server->type) {
                $table = set_prefix($server->db_prefix, 'servers');
                $STH = $connection->query("SELECT sid FROM {$table} WHERE ip='{$server->ip}' and port={$server->port} LIMIT 1");
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $row = $STH->fetch();
                $sid = $row->sid;

                $table1 = set_prefix($server->db_prefix, 'bans');
                $table2 = set_prefix($server->db_prefix, 'admins');
                $STH = $connection->query(
                    "SELECT 
						{$table1}.bid,
					    {$table1}.unban_type,
					    {$table1}.ban_closed,
					    {$table1}.ip AS player_ip,
					    {$table1}.RemoveType AS expired,
					    {$table1}.authid AS player_id,
					    {$table1}.name AS player_nick,
					    {$table1}.created AS ban_created,
					    {$table1}.length AS ban_length,
					    {$table1}.reason AS ban_reason,
					    {$table2}.user AS admin_nick,
					    {$table2}.nick AS admin_primary_nick,
					    {$table2}.authid AS admin_id,
					    {$table2}.user_id AS admin_user_id 
					FROM {$table1} 
						LEFT JOIN {$table2} ON {$table1}.aid = {$table2}.aid 
					WHERE {$table1}.sid = {$sid} OR {$table1}.sid = 0
					ORDER BY {$table1}.bid DESC 
					LIMIT {$start}, {$limit}"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
            }

            if (Integrations::IKS == $server->type) {
                $table1 = set_prefix($server->db_prefix, 'bans');
                $table2 = set_prefix($server->db_prefix, 'admins');
                $bansIds = fetchIdsForSqlIn(
                    $connection,
                    "SELECT {$table1}.id
						FROM {$table1} 
						WHERE {$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0
						GROUP BY {$table1}.id
						ORDER BY {$table1}.id DESC 
						LIMIT {$start}, {$limit}"
                );
                $STH = $connection->query(
                    "SELECT 
						{$table1}.id as bid,
						{$table1}.unban_type,
						{$table1}.ban_closed,
						{$table1}.ip AS player_ip,
						{$table1}.Unbanned AS expired,
						{$table1}.sid AS player_id,
						{$table1}.name AS player_nick,
						{$table1}.created AS ban_created,
						{$table1}.time AS ban_length,
						{$table1}.reason AS ban_reason,
						{$table1}.adminName AS admin_nick,
						{$table2}.name AS admin_primary_nick,
						{$table2}.sid AS admin_id,
						{$table2}.user_id AS admin_user_id 
					FROM {$table1} 
						LEFT JOIN {$table2} ON {$table1}.adminsid = {$table2}.sid 
					WHERE {$table1}.id IN ({$bansIds})
					ORDER BY {$table1}.id DESC"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
            }
        } else {
            if (
                Integrations::AMXBANS == $server->type
                || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
                || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
            ) {
                $table = set_prefix($server->db_prefix, 'bans');

                $STH = $connection->prepare(
                    prepareSearchQuery(
                        "SELECT 
									0 as admin_user_id,
									{$table}.* 
								FROM {$table} 
								WHERE server_ip = '{$address}'
								  AND (player_ip LIKE :name OR player_nick LIKE :name OR player_id LIKE :name OR bid = :bid) 
								ORDER BY bid DESC"
                    )
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute([':name' => getNameLike($name), ':bid' => $name]);
            }

            if (Integrations::SOURCEBANS == $server->type) {
                $table = set_prefix($server->db_prefix, 'servers');

                $STH = $connection->query("SELECT sid FROM {$table} WHERE ip='{$server->ip}' AND port={$server->port} LIMIT 1");
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $row = $STH->fetch();

                $sid = $row->sid;
                $table1 = set_prefix($server->db_prefix, 'bans');
                $table2 = set_prefix($server->db_prefix, 'admins');
                $STH = $connection->prepare(
                    prepareSearchQuery(
                        "SELECT 
									{$table1}.bid,
								    {$table1}.unban_type,
								    {$table1}.ban_closed,
								    {$table1}.ip AS player_ip,
								    {$table1}.RemoveType AS expired,
								    {$table1}.authid AS player_id,
								    {$table1}.name AS player_nick,
								    {$table1}.created AS ban_created,
								    {$table1}.length AS ban_length,
								    {$table1}.reason AS ban_reason,
								    {$table2}.user AS admin_nick,
								    {$table2}.nick AS admin_primary_nick,
								    {$table2}.authid AS admin_id,
									{$table2}.user_id AS admin_user_id  
								FROM {$table1} 
									LEFT JOIN {$table2} ON {$table1}.aid = {$table2}.aid 
								WHERE ({$table1}.sid = {$sid} OR {$table1}.sid = 0) 
								  AND ({$table1}.ip LIKE :name OR {$table1}.authid LIKE :name OR {$table1}.name LIKE :name OR {$table1}.bid = :bid) 
								ORDER BY {$table1}.bid DESC"
                    )
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute([':name' => getNameLike($name), ':bid' => $name]);
            }

            if (Integrations::IKS == $server->type) {
                $steamId64 = $steamIdOperations->GetSteamID64($name);

                $table1 = set_prefix($server->db_prefix, 'bans');
                $table2 = set_prefix($server->db_prefix, 'admins');

                if ($steamId64) {
                    $bansIds = fetchIdsForSqlIn(
                        $connection,
                        "SELECT {$table1}.id
							FROM {$table1} 
							WHERE ({$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0) AND ({$table1}.sid = :name) 
							GROUP BY {$table1}.id
							ORDER BY {$table1}.id DESC",
                        [':name' => $steamId64]
                    );
                } else {
                    $bansIds = fetchIdsForSqlIn(
                        $connection,
                        "SELECT {$table1}.id
							FROM {$table1} 
							WHERE ({$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0) 
							  AND ({$table1}.ip LIKE :name OR {$table1}.sid LIKE :name OR {$table1}.name LIKE :name OR {$table1}.id = :bid) 
							GROUP BY {$table1}.id
							ORDER BY {$table1}.id DESC",
                        [':name' => getNameLike($name), ':bid' => $name]
                    );
                }
                $STH = $connection->prepare(
                    prepareSearchQuery(
                        "SELECT 
										{$table1}.id as bid,
										{$table1}.unban_type,
										{$table1}.ban_closed,
										{$table1}.ip AS player_ip,
										{$table1}.Unbanned AS expired,
										{$table1}.sid AS player_id,
										{$table1}.name AS player_nick,
										{$table1}.created AS ban_created,
										{$table1}.time AS ban_length,
										{$table1}.reason AS ban_reason,
										{$table1}.adminName AS admin_nick,
										{$table2}.name AS admin_primary_nick,
										{$table2}.sid AS admin_id,
										{$table2}.user_id AS admin_user_id  
									FROM {$table1} 
										LEFT JOIN {$table2} ON {$table1}.adminsid = {$table2}.sid 
									WHERE {$table1}.id IN ({$bansIds})
									ORDER BY {$table1}.id DESC"
                    )
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute();
            }
        }

        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            $class = '';
            $price = 0;
            $isCanUnban = false;
            $isCanBuyUnban = false;

            $banLength = $row->ban_length;
            $banCreated = $row->ban_created;
            $banEndTime = 0;

            $banTimeTitle = '';
            $banClosedBy = '';

            if (is_worthy_specifically('s', $serverId)) {
                $isCanUnban = true;
            }

            if (is_auth()) {
                $isCanBuyUnban = true;
            }

            if (
                Integrations::AMXBANS == $server->type
                || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
                || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
            ) {
                $banLength *= 60;
                $banEndTime = $banCreated + $banLength;

                if (-2 == $row->unban_type) {
                    $banTimeTitle = 'Куплен разбан';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-1 == $row->unban_type || 1 == $row->expired) {
                    $banTimeTitle = 'Разбанен';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time())) {
                    $banTimeTitle = 'Срок истек';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (0 == $banLength) {
                    $banTimeTitle = 'Никогда';
                    $class = 'danger';
                    $price = $prices->price3;
                } else {
                    $banTimeTitle = expand_date($banEndTime);
                    if (($banEndTime - time()) < 60 * 60 * 24 * 7) {
                        $price = $prices->price1;
                    } else {
                        $price = $prices->price2;
                    }
                }
            }

            if (Integrations::SOURCEBANS == $server->type) {
                $banEndTime = $banCreated + $banLength;

                if (-2 == $row->unban_type) {
                    $banTimeTitle = 'Куплен разбан';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-1 == $row->unban_type || 'U' == $row->expired) {
                    $banTimeTitle = 'Разбанен';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time()) || 'E' == $row->expired) {
                    $banTimeTitle = 'Срок истек';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (0 == $banLength) {
                    $banTimeTitle = 'Никогда';
                    $class = 'danger';
                    $price = $prices->price3;
                } else {
                    $banTimeTitle = expand_date($banEndTime);
                    if (($banEndTime - time()) < 60 * 60 * 24 * 7) {
                        $price = $prices->price1;
                    } else {
                        $price = $prices->price2;
                    }
                }
            }

            if (Integrations::IKS == $server->type) {
                $row->admin_id = $steamIdOperations->GetSteamID32($row->admin_id);
                $row->player_id = $steamIdOperations->GetSteamID32($row->player_id);

                $banEndTime = $banCreated + $banLength;

                if (-2 == $row->unban_type) {
                    $banTimeTitle = 'Куплен разбан';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-1 == $row->unban_type || 1 == $row->expired) {
                    $banTimeTitle = 'Разбанен';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time())) {
                    $banTimeTitle = 'Срок истек';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (0 == $banLength) {
                    $banTimeTitle = 'Никогда';
                    $class = 'danger';
                    $price = $prices->price3;
                } else {
                    $banTimeTitle = expand_date($banEndTime);

                    if (($banEndTime - time()) < 60 * 60 * 24 * 7) {
                        $price = $prices->price1;
                    } else {
                        $price = $prices->price2;
                    }
                }
            }

            $adminNick = get_ban_admin_nick($row->admin_nick, $row->admin_primary_nick ?? null, $server->name, $server->type);

            if ($adminProfile = $this->get_gamer_profile($adminNick, $row->admin_id, $row->admin_user_id)) {
                $adminNick = $adminProfile;
            }

            if (!empty($row->ban_closed) && ($userProfile = $this->get_profile_by_id($row->ban_closed))) {
                $banClosedBy = $userProfile;
            }

            $this->tpl->load_template('elements/ban.tpl');
            $this->tpl->set('{class}', $class);
            $this->tpl->set('{bid}', $row->bid);
            $this->tpl->set('{player_nick}', check($row->player_nick));
            $this->tpl->set('{ban_reason}', check($row->ban_reason));
            $this->tpl->set('{server}', $server->id);
            $this->tpl->set('{time}', $banTimeTitle);
            $this->tpl->set('{isCanBuyUnban}', $isCanBuyUnban);
            $this->tpl->set('{price}', $price);
            $this->tpl->set('{address}', $address);
            $this->tpl->set('{admin_nick}', $adminNick);
            $this->tpl->set('{player_ip}', isNeedHidePlayerId() ? hidePlayerId($row->player_ip) : $row->player_ip);
            $this->tpl->set('{player_id}', isNeedHidePlayerId() ? hidePlayerId($row->player_id) : $row->player_id);
            $this->tpl->set('{ban_length}', expand_seconds2($banLength, 2));
            $this->tpl->set('{ban_created}', expand_date(date('Y-m-d H:i:s', $banCreated), 7));
            $this->tpl->set('{isCanUnban}', $isCanUnban);
            $this->tpl->set('{ban_closed}', $banClosedBy);
            $this->tpl->set('{ban_end}', 0 == $banLength ? '00.00.0000 00:00' : date('d.m.Y H:i', $banEndTime));
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }

        if (empty($this->tpl->result['local_content'])) {
            $this->tpl->result['local_content'] = tableRowError('Банов нет');
        }

        return $this->tpl->result['local_content'];
    }

    public function mutlist($start, $serverId, $limit = 30, $name = null)
    {
        $start = clean($start, 'int');
        $serverId = check($serverId, 'int');
        $name = check($name);

        global $messages;

        if (empty($serverId)) {
            return tableRowError('Не удалось загрузить данные');
        }

        $prices = pdo()->query('SELECT * FROM config__prices')->fetchObject();

        $server = ServerRepository::getById($serverId);
        if (empty($server)) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $steamIdOperations = new SteamIDOperations();
        $mutesService = new MutesService();
        $integrator = $mutesService->getIntegrator($server->type);
        if ($integrator->isBlank()) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        [$connection, $error] = $integrator->getStorageConnection($server);
        if ($error) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $address = "{$server->ip}:{$server->port}";

        if (
            Integrations::USERS_FILE == $server->type
            || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
            || Integrations::AMXBANS == $server->type
            || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
        ) {
            $table1 = 'comms';

            if (!check_table($table1, $connection)) {
                return tableRowError($messages['Not_found_tables']);
            }

            $table2 = 'admins';
            if (empty($name)) {
                $STH = $connection->prepare(
                    "SELECT 
						'' as admin_id,
						{$table1}.bid,
					    {$table1}.type,
					    {$table1}.expired AS unban_type,
					    {$table1}.modified_by AS ban_closed,
					    {$table1}.authid AS player_id,
					    {$table1}.name AS player_nick,
					    {$table1}.created AS ban_created,
					    {$table1}.length AS ban_length,
					    {$table1}.reason AS ban_reason,
					    {$table1}.admin_nick AS admin_primary_nick,
					    {$table2}.name AS admin_nick,
					    {$table2}.user_id AS admin_user_id 
					FROM {$table1} 
						LEFT JOIN {$table2} ON {$table1}.admin_id = {$table2}.id 
					WHERE {$table1}.server_id = :server_id 
					ORDER BY {$table1}.bid DESC 
					LIMIT {$start}, {$limit}"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute([':server_id' => $serverId]);
            } else {
                $STH = $connection->prepare(
                    prepareSearchQuery(
                        "SELECT 
									'' as admin_id,
									{$table1}.bid,
								    {$table1}.type,
								    {$table1}.expired AS unban_type,
								    {$table1}.modified_by AS ban_closed,
								    {$table1}.authid AS player_id,
								    {$table1}.name AS player_nick,
								    {$table1}.created AS ban_created,
								    {$table1}.length AS ban_length,
								    {$table1}.reason AS ban_reason,
								    {$table1}.admin_nick AS admin_primary_nick,
								    {$table2}.name AS admin_nick,
					    			{$table2}.user_id AS admin_user_id  
								FROM {$table1} 
									LEFT JOIN {$table2} ON {$table1}.admin_id = {$table2}.id 
								WHERE {$table1}.server_id = :server_id and ({$table1}.authid LIKE :name or {$table1}.name LIKE :name) 
								ORDER BY {$table1}.bid DESC"
                    )
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute([':server_id' => $serverId, ':name' => getNameLike($name)]);
            }
        }

        if (Integrations::SOURCEBANS == $server->type) {
            $table = set_prefix($server->db_prefix, 'comms');
            if (!check_table($table, $connection)) {
                return tableRowError($messages['Not_found_tables']);
            }

            $table = set_prefix($server->db_prefix, 'servers');
            $STH = $connection->query("SELECT sid FROM {$table} WHERE ip='{$server->ip}' and port={$server->port} LIMIT 1");
            $STH->setFetchMode(PDO::FETCH_OBJ);
            $row = $STH->fetch();
            $sid = $row->sid;

            $table1 = set_prefix($server->db_prefix, 'comms');
            $table2 = set_prefix($server->db_prefix, 'admins');

            if (empty($name)) {
                $STH = $connection->query(
                    "SELECT 
						{$table1}.bid,
						{$table1}.unban_type,
						{$table1}.ban_closed,
						{$table1}.type,
						{$table1}.RemoveType AS expired,
						{$table1}.authid AS player_id,
						{$table1}.name AS player_nick,
						{$table1}.created AS ban_created,
						{$table1}.length AS ban_length,
						{$table1}.reason AS ban_reason,
						{$table2}.user AS admin_nick,
						{$table2}.nick AS admin_primary_nick,
						{$table2}.authid AS admin_id,
						{$table2}.user_id AS admin_user_id  
					FROM {$table1} 
						LEFT JOIN {$table2} ON {$table1}.aid = {$table2}.aid 
					WHERE ({$table1}.sid = {$sid} or {$table1}.sid = '0') 
					ORDER BY {$table1}.bid DESC 
					LIMIT {$start}, {$limit}"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
            } else {
                $STH = $connection->prepare(
                    prepareSearchQuery(
                        "SELECT {$table1}.bid,
									{$table1}.unban_type,
									{$table1}.ban_closed,
									{$table1}.type,
									{$table1}.RemoveType AS expired,
									{$table1}.authid AS player_id,
									{$table1}.name AS player_nick,
									{$table1}.created AS ban_created,
									{$table1}.length AS ban_length,
									{$table1}.reason AS ban_reason,
									{$table2}.user AS admin_nick,
									{$table2}.nick AS admin_primary_nick,
									{$table2}.authid AS admin_id,
									{$table2}.user_id AS admin_user_id  
								FROM {$table1} 
									LEFT JOIN {$table2} ON {$table1}.aid = {$table2}.aid 
								WHERE ({$table1}.sid = {$sid} or {$table1}.sid = '0') and ({$table1}.authid LIKE :name or {$table1}.name LIKE :name) 
								ORDER BY {$table1}.bid DESC"
                    )
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute([':name' => getNameLike($name)]);
            }
        }

        if (Integrations::IKS == $server->type) {
            $steamId64 = $steamIdOperations->GetSteamID64($name);

            $table1 = set_prefix($server->db_prefix, 'mutes');
            $table2 = set_prefix($server->db_prefix, 'admins');

            if (empty($name)) {
                $mutesIds = fetchIdsForSqlIn(
                    $connection,
                    "SELECT {$table1}.id
						FROM {$table1} 
						WHERE {$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0
						GROUP BY {$table1}.id
						ORDER BY {$table1}.id DESC 
						LIMIT {$start}, {$limit}"
                );
                $STH = $connection->query(
                    "SELECT 
						'1' AS type,
						'' AS player_ip,
						{$table1}.id as bid,
						{$table1}.unban_type,
						{$table1}.ban_closed,
						{$table1}.Unbanned AS expired,
						{$table1}.sid AS player_id,
						{$table1}.name AS player_nick,
						{$table1}.created AS ban_created,
						{$table1}.time AS ban_length,
						{$table1}.reason AS ban_reason,
						{$table1}.adminName AS admin_nick,
						{$table2}.name AS admin_primary_nick,
						{$table2}.sid AS admin_id,
						{$table2}.user_id AS admin_user_id 
					FROM {$table1} 
						LEFT JOIN {$table2} ON {$table1}.adminsid = {$table2}.sid 
					WHERE {$table1}.id IN ({$mutesIds})
					ORDER BY {$table1}.id DESC 
					LIMIT {$start}, {$limit}"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
            } else {
                if ($steamId64) {
                    $mutesIds = fetchIdsForSqlIn(
                        $connection,
                        "SELECT {$table1}.id 
							FROM {$table1} 
							WHERE ({$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0) 
							  AND ({$table1}.sid = :name) 
							GROUP BY {$table1}.id
							ORDER BY {$table1}.id DESC",
                        [':name' => $steamId64]
                    );
                } else {
                    $mutesIds = fetchIdsForSqlIn(
                        $connection,
                        "SELECT {$table1}.id
							FROM {$table1} 
							WHERE ({$table1}.server_id = {$server->integration_server_id} OR {$table1}.server_id = 0) 
							  AND ({$table1}.sid LIKE :name OR {$table1}.name LIKE :name OR {$table1}.id = :bid) 
							GROUP BY {$table1}.id
							ORDER BY {$table1}.id DESC",
                        [':name' => getNameLike($name), ':bid' => $name]
                    );
                }
                $STH = $connection->prepare(
                    prepareSearchQuery(
                        "SELECT 
									'1' AS type,
									'' AS player_ip,
									{$table1}.id as bid,
									{$table1}.unban_type,
									{$table1}.ban_closed,
									{$table1}.Unbanned AS expired,
									{$table1}.sid AS player_id,
									{$table1}.name AS player_nick,
									{$table1}.created AS ban_created,
									{$table1}.time AS ban_length,
									{$table1}.reason AS ban_reason,
									{$table1}.adminName AS admin_nick,
									{$table2}.name AS admin_primary_nick,
									{$table2}.sid AS admin_id,
									{$table2}.user_id AS admin_user_id  
								FROM {$table1} 
									LEFT JOIN {$table2} ON {$table1}.adminsid = {$table2}.sid 
								WHERE {$table1}.id IN ({$mutesIds})
								ORDER BY {$table1}.id DESC"
                    )
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $STH->execute();
            }
        }

        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            $class = '';
            $price = 0;
            $isCanUnban = false;
            $isCanBuyUnban = false;

            $type = $row->type;
            $banLength = $row->ban_length;
            $banCreated = $row->ban_created;
            $banEndTime = 0;

            $banTimeTitle = '';
            $banClosedBy = '';

            if (is_worthy_specifically('s', $serverId)) {
                $isCanUnban = true;
            }

            if (is_auth()) {
                $isCanBuyUnban = true;
            }

            if (
                Integrations::USERS_FILE == $server->type
                || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
                || Integrations::AMXBANS == $server->type
                || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
            ) {
                $banLength = $banLength * 60;
                $banEndTime = $banCreated + $banLength;

                if ($banLength < 0) {
                    $banTimeTitle = 'На сессию';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-2 == $row->unban_type) {
                    $banTimeTitle = 'Куплен размут';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-1 == $row->unban_type) {
                    $banTimeTitle = 'Мут снят';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time())) {
                    $banTimeTitle = 'Срок истек';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (0 == $banLength) {
                    $banTimeTitle = 'Никогда';
                    $class = 'danger';
                    $price = $prices->price2_3;
                } else {
                    $banTimeTitle = expand_date($banEndTime);
                    if (($banEndTime - time()) < 60 * 60 * 24 * 7) {
                        $price = $prices->price2_1;
                    } else {
                        $price = $prices->price2_2;
                    }
                }
            }

            if (Integrations::SOURCEBANS == $server->type) {
                $banEndTime = $banCreated + $banLength;

                if ($banLength < 0) {
                    $banTimeTitle = 'На сессию';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-2 == $row->unban_type) {
                    $banTimeTitle = 'Куплен размут';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-1 == $row->unban_type || 'U' == $row->expired) {
                    $banTimeTitle = 'Мут снят';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time()) || 'E' == $row->expired) {
                    $banTimeTitle = 'Срок истек';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (0 == $banLength) {
                    $banTimeTitle = 'Никогда';
                    $class = 'danger';
                    $price = $prices->price2_3;
                } else {
                    $banTimeTitle = expand_date($banEndTime);
                    if (($banEndTime - time()) < 60 * 60 * 24 * 7) {
                        $price = $prices->price2_1;
                    } else {
                        $price = $prices->price2_2;
                    }
                }
            }

            if (Integrations::IKS == $server->type) {
                $row->admin_id = $steamIdOperations->GetSteamID32($row->admin_id);
                $row->player_id = $steamIdOperations->GetSteamID32($row->player_id);

                $banEndTime = $banCreated + $banLength;

                if ($banLength < 0) {
                    $banTimeTitle = 'На сессию';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-2 == $row->unban_type) {
                    $banTimeTitle = 'Куплен размут';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (-1 == $row->unban_type || 1 == $row->expired) {
                    $banTimeTitle = 'Мут снят';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (1 == $row->unban_type || (0 != $banLength && $banEndTime < time())) {
                    $banTimeTitle = 'Срок истек';
                    $class = 'success';
                    $isCanBuyUnban = false;
                    $isCanUnban = false;
                } elseif (0 == $banLength) {
                    $banTimeTitle = 'Никогда';
                    $class = 'danger';
                    $price = $prices->price2_3;
                } else {
                    $banTimeTitle = expand_date($banEndTime);

                    if (($banEndTime - time()) < 60 * 60 * 24 * 7) {
                        $price = $prices->price2_1;
                    } else {
                        $price = $prices->price2_2;
                    }
                }
            }

            $adminNick = get_ban_admin_nick($row->admin_nick, $row->admin_primary_nick ?? null, $server->name, $server->type);

            if ($adminProfile = $this->get_gamer_profile($adminNick, $row->admin_id, $row->admin_user_id)) {
                $adminNick = $adminProfile;
            }

            if (!empty($row->ban_closed) && ($userProfile = $this->get_profile_by_id($row->ban_closed))) {
                $banClosedBy = $userProfile;
            }

            $this->tpl->load_template('elements/mute.tpl');
            $this->tpl->set('{class}', $class);
            $this->tpl->set('{bid}', $row->bid);
            $this->tpl->set('{player_nick}', check($row->player_nick));
            $this->tpl->set('{ban_reason}', check($row->ban_reason));
            $this->tpl->set('{server}', $server->id);
            $this->tpl->set('{time}', $banTimeTitle);
            $this->tpl->set('{isCanBuyUnban}', $isCanBuyUnban);
            $this->tpl->set('{price}', $price);
            $this->tpl->set('{address}', $address);
            $this->tpl->set('{admin_nick}', $adminNick);
            $this->tpl->set('{player_id}', isNeedHidePlayerId() ? hidePlayerId($row->player_id) : $row->player_id);
            $this->tpl->set('{ban_length}', expand_seconds2($banLength, 2));
            $this->tpl->set('{ban_created}', expand_date(date('Y-m-d H:i:s', $banCreated), 7));
            $this->tpl->set('{type}', $type);
            $this->tpl->set('{isCanUnban}', $isCanUnban);
            $this->tpl->set('{ban_closed}', $banClosedBy);
            $this->tpl->set('{ban_end}', 0 == $banLength ? '00.00.0000 00:00' : date('d.m.Y H:i', $banEndTime));
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }

        if (empty($this->tpl->result['local_content'])) {
            return tableRowError('Мутов нет');
        }

        return $this->tpl->result['local_content'];
    }

    public function stats($start, $serverId, $limit = 30, $name = null)
    {
        $start = clean($start, 'int');
        $serverId = check($serverId, 'int');
        $name = check($name);

        global $messages;

        if (empty($serverId)) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $server = ServerRepository::getById($serverId);
        if (empty($server)) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $statisticsService = new StatisticsService();
        $integrator = $statisticsService->getIntegrator($server->st_type);
        if ($integrator->isBlank()) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        [$connection, $error] = $integrator->getStorageConnection($server);
        if ($error) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        return $integrator->renderCommonStatistics($server, $connection, $this->tpl, $name, $start, $limit);
    }

    public function stats_details($serverId, $id, $type)
    {
        $serverId = check($serverId, 'int');
        $id = check($id, 'int');

        global $messages;

        if (empty($id)) {
            return tableRowError($messages['informationNotFound']);
        }

        if (empty($serverId)) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $server = ServerRepository::getById($serverId);
        if (empty($server)) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        $statisticsService = new StatisticsService();
        $integrator = $statisticsService->getIntegrator($server->st_type);
        if ($integrator->isBlank()) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        [$connection, $error] = $integrator->getStorageConnection($server);
        if ($error) {
            return tableRowError($messages['errorConnectingToDatabase']);
        }

        switch ($type) {
            case 'weapons':
                $result = $integrator->renderWeaponsStatistics($server, $connection, $this->tpl, $id);

                break;

            case 'maps':
                $result = $integrator->renderMapsStatistics($server, $connection, $this->tpl, $id);

                break;

            default:
                $result = '';
        }

        return $result;
    }

    public function news($start, $class, $limit = 10)
    {
        $start = clean($start, 'int');
        $class = check($class, 'int');
        $limit = check($limit, 'int');

        if (empty($limit)) {
            $limit = 10;
        }

        $date = date('Y-m-d H:i:s');
        if (is_worthy('q')) {
            if (empty($class)) {
                $STH = pdo()->query("SELECT news.id,news.class,news.new_name,news.img,news.short_text,news.date,news.author,news.views,users.login,users.avatar,news.views FROM news LEFT JOIN users ON news.author = users.id ORDER BY news.date DESC LIMIT {$start}, {$limit}");
                $STH->setFetchMode(PDO::FETCH_OBJ);
            } else {
                $STH = pdo()->query("SELECT news.id,news.class,news.new_name,news.img,news.short_text,news.date,news.author,news.views,users.login,users.avatar,news.views FROM news LEFT JOIN users ON news.author = users.id WHERE news.class = {$class} ORDER BY news.date DESC LIMIT {$start}, {$limit}");
                $STH->setFetchMode(PDO::FETCH_OBJ);
            }
        } else {
            if (empty($class)) {
                $STH = pdo()->query("SELECT news.id,news.class,news.new_name,news.img,news.short_text,news.date,news.author,news.views,users.login,users.avatar,news.views FROM news LEFT JOIN users ON news.author = users.id WHERE news.date < '{$date}' ORDER BY news.date DESC LIMIT {$start}, {$limit}");
                $STH->setFetchMode(PDO::FETCH_OBJ);
            } else {
                $STH = pdo()->query("SELECT news.id,news.class,news.new_name,news.img,news.short_text,news.date,news.author,news.views,users.login,users.avatar,news.views FROM news LEFT JOIN users ON news.author = users.id WHERE news.date < '{$date}' and news.class = {$class} ORDER BY news.date DESC LIMIT {$start}, {$limit}");
                $STH->setFetchMode(PDO::FETCH_OBJ);
            }
        }

        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            if ($row->date > $date) {
                $row->new_name = '(Ожидает публикации) '.$row->new_name;
            }
            $this->tpl->load_template('elements/new.tpl');
            $this->tpl->set('{id}', $row->id);
            $this->tpl->set('{new_name}', $row->new_name);
            $this->tpl->set('{img}', $row->img);
            $this->tpl->set('{short_text}', $row->short_text);
            $this->tpl->set('{author}', $row->author);
            $this->tpl->set('{login}', $row->login);
            $this->tpl->set('{date}', expand_date($row->date, 2));
            $this->tpl->set('{avatar}', $row->avatar);
            $this->tpl->set('{views}', $row->views);
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }
        if ('' == $this->tpl->result['local_content']) {
            $this->tpl->result['local_content'] = '<span class="empty-element">Новостей нет</span>';
        }

        return $this->tpl->result['local_content'];
    }

    public function users($start, $group, $limit = 12)
    {
        $start = clean($start, 'int');
        $limit = check($limit, 'int');
        if ('multi_accounts' === $group && (is_worthy('f') || is_worthy('g'))) {
            $group = 'multi_accounts';
        } else {
            $group = check($group, 'int');
        }

        global $users_groups;

        if (empty($group)) {
            $group = 0;
        }
        if (empty($limit)) {
            $limit = 12;
        }

        if ('multi_accounts' === $group) {
            $STH = pdo()->query("SELECT id,login,avatar,rights FROM users WHERE active='1' AND multi_account!='0' LIMIT {$start}, {$limit}");
            $STH->setFetchMode(PDO::FETCH_OBJ);
        } elseif (0 == $group) {
            $STH = pdo()->query("SELECT id,login,avatar,rights FROM users WHERE active='1' LIMIT {$start}, {$limit}");
            $STH->setFetchMode(PDO::FETCH_OBJ);
        } else {
            $STH = pdo()->query("SELECT id,login,avatar,rights FROM users WHERE active='1' AND rights='{$group}' LIMIT {$start}, {$limit}");
            $STH->setFetchMode(PDO::FETCH_OBJ);
        }

        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            $group = $users_groups[$row->rights];
            $this->tpl->load_template('elements/user.tpl');
            $this->tpl->set('{login}', $row->login);
            $this->tpl->set('{id}', $row->id);
            $this->tpl->set('{avatar}', $row->avatar);
            $this->tpl->set('{gp_name}', $group['name']);
            $this->tpl->set('{gp_color}', $group['color']);
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }

        return $this->tpl->result['local_content'];
    }

    public function search_login($login, $group)
    {
        $login = check($login, null);
        if ('multi_accounts' === $group && (is_worthy('f') || is_worthy('g'))) {
            $group = 'multi_accounts';
        } else {
            $group = check($group, 'int');
        }

        if (empty($login)) {
            return '<span class="empty-element">Введите логин пользователя</span>';
        }
        if (empty($group)) {
            $group = 0;
        }

        global $users_groups;

        if ('multi_accounts' === $group) {
            $STH = pdo()->prepare(
                prepareSearchQuery(
                    "SELECT id,login,avatar,nick,birth,skype,vk,rights,name,regdate FROM users WHERE active='1' and login LIKE :login or id = :id AND multi_account!='0'"
                )
            );
            $STH->setFetchMode(PDO::FETCH_OBJ);
            $STH->execute([':login' => getNameLike($login), ':id' => $login]);
        } elseif (0 == $group) {
            $STH = pdo()->prepare(
                prepareSearchQuery(
                    "SELECT id,login,avatar,nick,birth,skype,vk,rights,name,regdate FROM users WHERE active='1' and login LIKE :login or id = :id"
                )
            );
            $STH->setFetchMode(PDO::FETCH_OBJ);
            $STH->execute([':login' => getNameLike($login), ':id' => $login]);
        } else {
            $STH = pdo()->prepare(
                prepareSearchQuery(
                    "SELECT id,login,avatar,nick,birth,skype,vk,rights,name,regdate FROM users WHERE active='1' and rights=:group and (login LIKE :login or id = :id)"
                )
            );
            $STH->setFetchMode(PDO::FETCH_OBJ);
            $STH->execute([':login' => getNameLike($login), ':id' => $login, ':group' => $group]);
        }
        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            $group = $users_groups[$row->rights];

            $this->tpl->load_template('elements/user_full.tpl');
            $this->tpl->set('{login}', $row->login);
            $this->tpl->set('{id}', $row->id);
            $this->tpl->set('{avatar}', $row->avatar);
            $this->tpl->set('{gp_name}', $group['name']);
            $this->tpl->set('{date}', expand_date($row->regdate, 2));
            $this->tpl->set('{date2}', expand_date($row->birth, 2));
            $this->tpl->set('{nick}', $row->nick);
            $this->tpl->set('{skype}', $row->skype);
            $this->tpl->set('{vk}', $row->vk);
            $this->tpl->set('{name}', $row->name);
            $this->tpl->set('{gp_color}', $group['color']);
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }
        if ('' == $this->tpl->result['local_content']) {
            $this->tpl->result['local_content'] = '<span class="empty-element">Пользователь с данным логином не найден.</span>';
        }

        return $this->tpl->result['local_content'];
    }

    public function bans_applications($start, $server, $limit = 10)
    {
        global $messages;

        $start = clean($start, 'int');
        $server = check($server, 'int');
        $limit = check($limit, 'int');

        if (empty($limit)) {
            $limit = 10;
        }

        if (empty($server)) {
            $STH = pdo()->query("SELECT bans.id,bans.server,bans.status,bans.nick,bans.date,bans.author,users.login,users.avatar,servers.name FROM bans LEFT JOIN users ON bans.author = users.id LEFT JOIN servers ON bans.server = servers.id ORDER BY date DESC LIMIT {$start}, {$limit}");
            $STH->setFetchMode(PDO::FETCH_OBJ);
        } else {
            $STH = pdo()->query("SELECT bans.id,bans.server,bans.status,bans.nick,bans.date,bans.author,users.login,users.avatar,servers.name FROM bans LEFT JOIN users ON bans.author = users.id LEFT JOIN servers ON bans.server = servers.id WHERE bans.server = {$server} ORDER BY date DESC LIMIT {$start}, {$limit}");
            $STH->setFetchMode(PDO::FETCH_OBJ);
        }
        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            if (0 == $row->status) {
                $status = $messages['Not_reviewed'];
                $color = 'warning';
            }
            if (1 == $row->status) {
                $status = $messages['Unbaned'];
                $color = 'success';
            }
            if (2 == $row->status) {
                $status = $messages['Do_not_unbaned'];
                $color = 'danger';
            }
            $this->tpl->load_template('elements/ban_application.tpl');
            $this->tpl->set('{color}', $color);
            $this->tpl->set('{id}', $row->id);
            $this->tpl->set('{nick}', $row->nick);
            $this->tpl->set('{author}', $row->author);
            $this->tpl->set('{login}', $row->login);
            $this->tpl->set('{avatar}', $row->avatar);
            $this->tpl->set('{status}', $status);
            $this->tpl->set('{name}', $row->name);
            $this->tpl->set('{date}', expand_date($row->date, 7));
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }
        if ('' == $this->tpl->result['local_content']) {
            $this->tpl->result['local_content'] = tableRowError('Заявок нет');
        }

        return $this->tpl->result['local_content'];
    }

    public function getAdmins($server = 0, $userId = null, $name = null, $adminId = null)
    {
        $server = clean($server, 'int');
        $userId = clean($userId, 'int');
        $name = clean($name, null);
        $adminId = clean($adminId, 'int');

        global $users_groups;

        $admins = [];
        $whereData = [];
        $where = [];

        if (!empty($server)) {
            $where[] = '(admins.server = :server) ';
            $whereData[':server'] = $server;
        }

        if (!empty($name)) {
            $where[] = '(admins.name LIKE :name OR users.login LIKE :name OR users.nick LIKE :name) ';
            $whereData[':name'] = getNameLike($name);
        }

        if (!empty($userId)) {
            $where[] = '(users.id = :userId) ';
            $whereData[':userId'] = $userId;
        }

        if (!empty($where)) {
            $where = ' WHERE '.implode(' AND ', $where);
        }

        if (!empty($adminId)) {
            $where = ' WHERE admins.id = :adminId ';
            $whereData = [];
            $whereData[':adminId'] = $adminId;
        }

        $STH = pdo()->prepare(
            prepareSearchQuery(
                "SELECT 
    									admins.id, 
    									admins.type, 
    									admins.name, 
    									admins.cause, 
    									admins.price, 
    									admins.link, 
    									admins.active, 
    									admins.user_id, 
    									users.login, 
    									users.avatar, 
    									users.rights, 
										servers.name as server_name,
    									servers.id as server_id
										FROM 
										    admins
							  				LEFT JOIN 
										        users 
										            ON users.id = admins.user_id
										    LEFT JOIN 
										        servers 
										            ON servers.id = admins.server 
							  		{$where}
									ORDER BY admins.id"
            )
        );
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute($whereData);
        while ($row = $STH->fetch()) {
            $STH2 = pdo()->prepare(
                'SELECT 
					    services.name, 
					    services.show_adm 
					FROM 
					    admins__services 
					        LEFT JOIN 
					        services 
					            ON 
					                admins__services.service = services.id 
					WHERE admins__services.admin_id=:admin_id LIMIT 10'
            );
            $STH2->setFetchMode(PDO::FETCH_OBJ);
            $STH2->execute([':admin_id' => $row->id]);

            $show = 0;
            $services = '';
            while ($row2 = $STH2->fetch()) {
                if (empty($row2->show_adm) or 1 == $row2->show_adm) {
                    if (empty($row2->name)) {
                        $row2->name = 'Неизвестно';
                    }
                    if ('' == $services) {
                        $services .= $row2->name;
                    } else {
                        $services .= ' + '.$row2->name;
                    }
                    ++$show;
                }
            }

            if (empty($row->rights)) {
                $row->rights = 0;
            }
            if (empty($row->login)) {
                $row->login = 0;
            }
            if (empty($row->name)) {
                $row->name = 0;
            }
            if (empty($row->avatar)) {
                $row->avatar = 0;
            }

            $admins[] = [
                'id' => $row->id,
                'show' => $show > 0,
                'server' => $row->server_name,
                'server_id' => $row->server_id,
                'services' => $services,
                'active' => $row->active,
                'cause' => $row->cause,
                'price' => $row->price,
                'link' => $row->link,
                'user_id' => $row->user_id,
                'login' => $row->login,
                'name' => isNeedHideAdminId() ? hidePlayerId($row->name) : $row->name,
                'name_original' => $row->name,
                'avatar' => $row->avatar,
                'type' => $row->type,
                'gp_name' => $users_groups[$row->rights]['name'],
                'gp_color' => $users_groups[$row->rights]['color'],
            ];
        }

        return $admins;
    }

    public function servers_admins($server_id)
    {
        global $messages;

        $server_id = clean($server_id, 'int');

        $adminsService = new AdminsService();
        $servers = [];

        if ($server_id) {
            $servers[] = ServerRepository::getById($server_id);
        } else {
            $servers = ServerRepository::getAll();
        }

        $this->tpl->result['local_content'] = '';
        foreach ($servers as $server) {
            $integrator = $adminsService->getIntegrator($server->type);
            if ($integrator->isBlank()) {
                continue;
            }

            $i = 0;
            $this->tpl->result['admin'] = '';
            $admins = $this->getAdmins($server->id);

            foreach ($admins as $admin) {
                if ($admin['show']) {
                    ++$i;

                    $admin['i'] = $i;
                    $admin['server'] = '';
                    $this->tpl->load_template('elements/admin.tpl');
                    foreach ($admin as $key => $value) {
                        $this->tpl->set('{'.$key.'}', $value);
                    }
                    $this->tpl->compile('admin');
                    $this->tpl->clear();
                }
            }

            if ('' == $this->tpl->result['admin']) {
                $this->tpl->result['admin'] = tableRowError($messages['informationNotFound']);
            }

            $this->tpl->load_template('elements/admins.tpl');
            $this->tpl->set('{server_name}', $server->name);
            $this->tpl->set('{server_id}', $server->id);
            $this->tpl->set('{admins}', $this->tpl->result['admin'], false);
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }

        return $this->tpl->result['local_content'];
    }

    public function price_list()
    {
        $STH = pdo()->query('SELECT discount FROM config__prices LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        $discount = $row->discount;

        global $user;

        if (empty($user)) {
            $user_proc = 0;
        } else {
            $user_proc = $user->proc;
        }

        $this->tpl->result['local_content'] = '';
        $STH = pdo()->query("SELECT `id`, `address`, `name`, `discount` FROM `servers` WHERE `type`!='0'");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        while ($server = $STH->fetch()) {
            $this->tpl->result['services'] = '';
            $STH2 = pdo()->prepare("SELECT `id`, `name`, `text`, `discount` FROM `services` WHERE `server`=:server AND `sale`='1' ORDER BY `trim`");
            $STH2->setFetchMode(PDO::FETCH_OBJ);
            $STH2->execute([':server' => $server->id]);
            while ($service = $STH2->fetch()) {
                $i = 0;
                $tarifs = '';
                $STH3 = pdo()->prepare('SELECT `id`, `price`, `time`, `discount` FROM `services__tarifs` WHERE `service`=:service');
                $STH3->setFetchMode(PDO::FETCH_OBJ);
                $STH3->execute([':service' => $service->id]);
                while ($tarif = $STH3->fetch()) {
                    ++$i;
                    if (0 == $tarif->time) {
                        $time = 'Навсегда';
                    } else {
                        $time = $tarif->time.' дней';
                    }
                    $proc = calculate_discount($server->discount, $discount, $user_proc, $service->discount, $tarif->discount);
                    $price = calculate_price($tarif->price, $proc);
                    $tarifs .= '<tr>
									<td>'.$i.'</td>
									<td>'.$time.'</td>
									<td>'.$price.'</td>
								</tr>';
                }
                $this->tpl->load_template('/elements/price_list_service.tpl');
                $this->tpl->set('{service_name}', $service->name);
                $this->tpl->set('{service_text}', $service->text);
                $this->tpl->set('{tarifs}', $tarifs);
                $this->tpl->compile('services');
                $this->tpl->clear();
            }
            $this->tpl->load_template('/elements/price_list_server.tpl');
            $this->tpl->set('{server_name}', $server->name);
            $this->tpl->set('{server_ip}', $server->address);
            $this->tpl->set('{services}', $this->tpl->result['services'], false);
            $this->tpl->compile('local_content');
            $this->tpl->clear();
        }

        return $this->tpl->result['local_content'];
    }

    public function notifications($start, $limit = 10, $isNeedNew = false)
    {
        $start = clean($start, 'int');
        $limit = check($limit, 'int');

        $limitExpression = '';

        if (!empty($limit)) {
            $limitExpression = "LIMIT {$start}, {$limit}";
        }

        if ($isNeedNew) {
            $STH = pdo()->query("SELECT * FROM `notifications` WHERE user_id='{$_SESSION['id']}' and status='0' ORDER BY date DESC {$limitExpression}");
        } else {
            $STH = pdo()->query("SELECT * FROM notifications WHERE user_id='{$_SESSION['id']}' ORDER BY date DESC {$limitExpression}");
        }

        $STH->setFetchMode(PDO::FETCH_OBJ);
        $this->tpl->result['local_content'] = '';
        while ($row = $STH->fetch()) {
            $class = '';

            if (1 == $row->type) {
                $class = 'info';
            }
            if (2 == $row->type) {
                $class = 'success';
            }
            if (3 == $row->type) {
                $class = 'error';
            }

            $text = find_img_mp3($row->message, 1);
            $this->tpl->load_template('/elements/notification.tpl');
            $this->tpl->set('{class}', $class);
            $this->tpl->set('{date}', expand_date($row->date, 7));
            $this->tpl->set('{text}', $text);

            if ($isNeedNew) {
                $this->tpl->set('{function}', 'close_notification');
            } else {
                $this->tpl->set('{function}', 'dell_notification');
            }

            $this->tpl->set('{id}', $row->id);
            $this->tpl->compile('local_content');
            $this->tpl->clear();

            if ($isNeedNew) {
                $this->tpl->result['local_content'] .= '<script>$("#notifications_line").removeClass("disp-n");</script>';
                $this->tpl->result['local_content'] .= '<script>$("#notifications_line").addClass("disp-b");</script>';
            } else {
                $this->tpl->result['local_content'] .= '<script>$("#notifications_line").removeClass("disp-n");</script>';
            }
        }

        return $this->tpl->result['local_content'];
    }

    private function get_profile_by_id($user_id)
    {
        $STH = pdo()->prepare('SELECT id, login, avatar, rights FROM users WHERE id=:id LIMIT 1');
        $STH->execute([':id' => $user_id]);
        $row = $STH->fetchObject();

        if (isset($row->id)) {
            return $this->renderProfile(
                $row->id,
                $row->login,
                $row->avatar,
                users_groups()[$row->rights]['name'],
                users_groups()[$row->rights]['color']
            );
        }

        return '';
    }

    private function renderProfile(
        int $userId,
        string $login,
        string $avatar,
        string $groupName,
        string $groupStyle
    ): string {
        return "<a target=\"_blank\" href=\"../profile?id={$userId}\" title=\"{$groupName}\">
					<img src=\"../{$avatar}\" alt=\"{$login}\" class=\"small_us_av\"> 
					<i style=\"color: {$groupStyle}\"> {$login} </i>
				</a>";
    }
}
