<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, представляющий список операций. Содержит разбиение по страницам для отображения длинных списков.
	 * A list of transactions. Long transaction lists are split into multiple pages.
	 * 
 */
class OperationInfoList
{
	
	/**
	 * Количество операций, возвращаемых в результате запроса.
	 * The maximum number of transactions that the response must return on a single page.
	 * 
	 *
	 * @var long
	 */
	 public $pageSize = null;

	/**
	 * Номер текущей страницы. Нумерация начинается с 1.
	 * The current page number. Page numbering starts from 1.
	 * 
	 *
	 * @var long
	 */
	 public $pageNumber = null;

	/**
	 * Максимальное количество страниц с операциями по данному запросу.
	 * The total number of pages for a given request.
	 * 
	 *
	 * @var long
	 */
	 public $pagesCount = null;

	/**
	 * Количество операций на текущей странице. Меньше или равно pageSize. Последняя страница может содержать операций меньше, чем pageSize.
	 * The number of transactions on the current page. This number is less than or equal to the pageSize number.
	 * 
	 *
	 * @var long
	 */
	 public $size = null;

	/**
	 * Общее количество операций, которое можно получить в данной выборке.
	 * The total number of transactions for a given request.
	 * 
	 *
	 * @var long
	 */
	 public $totalSize = null;

	/**
	 * Список операций.
	 * The list of transactions.
	 * 
	 *
	 * @var OperationInfo
	 */
	 public $operation = null;

	/**
	 * Список операций.
	 * The list of transactions.
	 * 
	 *
	 * @param OperationInfo
	 *
	 * @return void
	 */
	public function addOperation(OperationInfo $item)
	{
		$this->operation[] = $item;
	}

}
