<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Шаблон операции.
	 * Operation template.
	 * 
 */
class OperationTemplate extends AbstractAttributeObject
{
	
	/**
	 * Идентификатор шаблона операции. При создании шаблона операции (CreateOperationTemplateRequest) должен иметь пустое значение.
	 * 
	 *
	 * @var long
	 */
	 public $id = null;

	/**
	 * Пользователь, которому принадлежит шаблон операции.
	 * Если при создании шаблона операции это поле не задано, то используется текущий пользователь.
	 * При редактировании шаблона операции это поле передавать нельзя.
	 * The owner of the operation template. If you omit this element, the request uses the name of the user who sends the request.
	 * 
	 *
	 * @var long
	 */
	 public $unitId = null;

	/**
	 * Тип шаблона операции.
	 * При редактировании шаблона этот элемент можно не передавать. При создании шаблона этот элемент обязателен.
	 * При редактировании шаблона можно менять его тип. То есть регулярный шаблон можно сделать нерегулярным и наоборот.
	 * При смене типа шаблона следует передать все необходимые параметры шаблона: commonParameters или regularParameters.
	 * Operation template type.
	 * 
	 *
	 * @var string
	 */
	 public $type = null;

	/**
	 * Название шаблона.
	 * Максимальная длина 250 символов.
	 * При редактировании шаблона этот элемент можно не передавать. При создании шаблона этот элемент обязателен.
	 * Operation template name.
	 * 
	 *
	 * @var string
	 */
	 public $name = null;

	/**
	 * Номер счета плательщика.
	 * Этот элемент следует обязательно передавать при создании нового шаблона.
	 * Если шаблон создается из проведенной операции или редактируется, то этот элемент необязателен.
	 * Account number of the payer.
	 * 
	 *
	 * @var long
	 */
	 public $payer = null;

	/**
	 * Номер счета получателя.
	 * Этот элемент следует обязательно передавать при создании нового шаблона.
	 * Если шаблон создается из проведенной операции или редактируется, то этот элемент необязателен.
	 * Account number of the payee.
	 * 
	 *
	 * @var long
	 */
	 public $payee = null;

	/**
	 * Категория операции.
	 * Возвращается при чтении шаблона операции.
	 * Transaction category.
	 * 
	 *
	 * @var string
	 */
	 public $operationTypeCategory = null;

	/**
	 * Описание шаблона.
	 * Максимальная длина 255 символов.
	 * Operation template description.
	 * 
	 *
	 * @var normalizedString
	 */
	 public $description = null;

	/**
	 * Номер операции, на основе которой был создан шаблон.
	 * 
	 *
	 * @var long
	 */
	 public $prototypeOperationId = null;

	/**
	 * Метки шаблона. Для логической группировки шаблонов и быстрого поиска по нужной метке.
	 * Метки могут содержать русские или английские символы, цифры, символы "_" и "-", пробел.
	 * Метки могут разделяться запятыми. Длина одной метки не может быть больше 128 байт.
	 * Например: "банковские переводы, еженедельные выплаты, сбербанк".
	 * 
	 *
	 * @var string
	 */
	 public $tags = null;

	/**
	 * Шаблон операции добавлен в категорию "избранное".
	 * 
	 *
	 * @var boolean
	 */
	 public $favorite = null;

	/**
	 * Набор полей, которые необходимо сохранить в качестве атрибутов операции.
	 * Key-value pairs that will be saved as transaction attributes.
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $operationInfo = null;

	/**
	 * Набор полей, которые необходимо сохранить в качестве атрибутов операции.
	 * Key-value pairs that will be saved as transaction attributes.
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addOperationInfo(KeyValueAttribute $item)
	{
		$this->operationInfo[] = $item;
	}

	/**
	 * Дополнительные поля шаблона операции. Только для чтения.
	 * Например:
	 * executionlastdatetime. Время последнего выполнения шаблона. Может возвращаться, если поиск был по "идентификатору шаблона".
	 * executionlastoperationid. Номер операции, которая была создана во время последнего выполнения шаблона. Может возвращаться, если поиск был по "идентификатору шаблона".
	 * executionlastmessage. Если во время последнего выполнения шаблона была ошибка, то это поле может содержать текст ошибки. Может возвращаться, если поиск был по "идентификатору шаблона".
	 * payer_alias. Название счета плательщика. Может возвращаться, если поиск был по "фильтру".
	 * payee_alias. Название счета получателя. Может возвращаться, если поиск был по "фильтру".
	 * payer_currency. Валюта счета плательщика. Может возвращаться, если поиск был по "фильтру".
	 * payee_currency. Валюта счета получателя. Может возвращаться, если поиск был по "фильтру".
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $additionalInfo = null;

	/**
	 * Дополнительные поля шаблона операции. Только для чтения.
	 * Например:
	 * executionlastdatetime. Время последнего выполнения шаблона. Может возвращаться, если поиск был по "идентификатору шаблона".
	 * executionlastoperationid. Номер операции, которая была создана во время последнего выполнения шаблона. Может возвращаться, если поиск был по "идентификатору шаблона".
	 * executionlastmessage. Если во время последнего выполнения шаблона была ошибка, то это поле может содержать текст ошибки. Может возвращаться, если поиск был по "идентификатору шаблона".
	 * payer_alias. Название счета плательщика. Может возвращаться, если поиск был по "фильтру".
	 * payee_alias. Название счета получателя. Может возвращаться, если поиск был по "фильтру".
	 * payer_currency. Валюта счета плательщика. Может возвращаться, если поиск был по "фильтру".
	 * payee_currency. Валюта счета получателя. Может возвращаться, если поиск был по "фильтру".
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addAdditionalInfo(KeyValueAttribute $item)
	{
		$this->additionalInfo[] = $item;
	}

}
