<?php

use Curl\Curl;
use GameCMS\Integrations\Integrations;
use GameCMS\Repositories\ServerRepository;
use GameCMS\Services\AdminsService;
use GameCMS\Services\BansService;
use GameCMS\Services\MutesService;
use Moneta\MonetaSdk;
use Qiwi\Api\BillPayments;
use YooKassa\Client;

include_once __DIR__.'/../inc/start.php';

include_once __DIR__.'/../inc/protect.php';

global $conf, $pdo, $full_site_host, $SC, $users_groups, $messages, $protocol, $host, $token;

$AjaxResponse = new AjaxResponse();

if (!isPostRequest() || !isRightToken() || !is_auth()) {
    $AjaxResponse->status(false)->alert('Ошибка')->send();
}

global $messages;
global $full_site_host;

if (isset($_POST['refill_balance'])) {
    $amount = check($_POST['number'], 'float');
    $cashierSlug = check($_POST['type'], null);

    try {
        if (empty($amount)) {
            throw new Exception('Вы не указали сумму!');
        }

        $row = pdo()->query('SELECT min_amount FROM config__secondary LIMIT 1')->fetch(PDO::FETCH_OBJ);

        if ($amount < $row->min_amount) {
            throw new Exception('Не менее '.$row->min_amount.$messages['RUB']);
        }

        $Pm = new Payments();

        $payId = $Pm->generatePayId();
        $orderDesc = $Pm->generatePayDescription(clean_name(configs()->name));

        if (empty($cashierSlug)) {
            throw new Exception('Неверный тип');
        }

        $cashier = $Pm->getCashier($cashierSlug);

        if (empty($cashier)) {
            throw new Exception('Неверный тип');
        }

        if (!$Pm->isCashierEnable($cashierSlug)) {
            throw new Exception('Способ оплаты неактивен');
        }

        $cashierSettings = pdo()->query('SELECT * FROM config__bank LIMIT 1')->fetch(PDO::FETCH_OBJ);

        switch ($cashierSlug) {
            case 'ik':
                if (empty($cashierSettings->ik_login) || empty($cashierSettings->ik_pass1)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $currency = Payments::getCashierCurrency('ik');

                $parameters = [
                    'ik_am' => $amount,
                    'ik_co_id' => $cashierSettings->ik_login,
                    'ik_cur' => $currency,
                    'ik_desc' => $orderDesc,
                    'ik_pm_no' => $payId,
                    'ik_x_id' => user()->id,
                ];
                ksort($parameters, SORT_STRING);

                $url = 'https://sci.interkassa.com/';
                $parameters['ik_sign'] = base64_encode(
                    md5(implode(':', array_merge($parameters, [$cashierSettings->ik_pass1])), true)
                );

                Payments::showForm($url, $parameters);

                break;

            case 'ya':
                if (empty($cashierSettings->ya_num) || empty($cashierSettings->ya_key)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $payId = str_pad(user()->id, 7, '0', STR_PAD_LEFT).substr($payId, 5);

                $url = 'https://yoomoney.ru/quickpay/confirm.xml';
                $parameters = [
                    'receiver' => $cashierSettings->ya_num,
                    'formcomment' => '',
                    'short-dest' => '',
                    'label' => $payId,
                    'quickpay-form' => 'donate',
                    'targets' => $orderDesc,
                    'sum' => $amount,
                    'comment' => '',
                    'need-fio' => 'false',
                    'need-email' => 'false',
                    'need-phone' => 'false',
                    'need-address' => 'false',
                    'paymentType' => '',
                    'successURL' => $full_site_host.'purse?result_ya=success',
                ];

                Payments::showForm($url, $parameters);

                break;

            case 'fk':
                if (empty($cashierSettings->fk_login) || empty($cashierSettings->fk_pass1)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $cashierId = $cashierSettings->fk_login;
                $cashierPublicKey = $cashierSettings->fk_pass1;
                $orderNumber = substr($payId, 5);

                $parameters = [
                    'm' => $cashierId,
                    'oa' => $amount,
                    'o' => $orderNumber,
                    's' => md5("{$cashierId}:{$amount}:{$cashierPublicKey}:{$orderNumber}"),
                    'us_user' => user()->id,
                ];

                if (isEmailIntroduced(user()->email)) {
                    $parameters['em'] = user()->email;
                }

                $url = 'https://www.free-kassa.ru/merchant/cash.php';

                Payments::showLink($url, $parameters);

                break;

            case 'fk_new':
                if (empty($cashierSettings->fk_new_login) || empty($cashierSettings->fk_new_pass1)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $cashierId = $cashierSettings->fk_new_login;
                $cashierPublicKey = htmlspecialchars_decode($cashierSettings->fk_new_pass1);
                $cashierApiKey = $cashierSettings->fk_new_api_key;
                $orderNumber = substr($payId, 5);
                $currency = Payments::getCashierCurrency('fk_new');

                if (2 == $cashierSettings->fk_new_mode) {
                    $parameters = [
                        'm' => $cashierId,
                        'oa' => $amount,
                        'o' => $orderNumber,
                        'currency' => $currency,
                        's' => md5(
                            "{$cashierId}:{$amount}:{$cashierPublicKey}:{$currency}:{$orderNumber}"
                        ),
                        'us_user' => user()->id,
                    ];

                    if (isEmailIntroduced(user()->email)) {
                        $parameters['em'] = user()->email;
                    }

                    $url = 'https://pay.fk.money/';

                    Payments::showLink($url, $parameters);
                } else {
                    $url = 'https://api.fk.life/v1/orders/create';

                    $parameters = [
                        'shopId' => $cashierId,
                        'nonce' => $payId,
                        'paymentId' => rand(100000, 999999).user()->id,
                        'i' => getConfigAdditional('fk_newI', 36),
                        'ip' => get_ip(),
                        'amount' => $amount,
                        'currency' => $currency,
                    ];

                    if (isEmailIntroduced(user()->email)) {
                        $parameters['email'] = user()->email;
                    } else {
                        $emailLogin = translit(
                            preg_replace('/[^a-zA-Zа-яёЁА-Я0-9]/ui', '', user()->login)
                        );
                        $parameters['email'] = "{$emailLogin}@{$host}";
                    }

                    ksort($parameters);
                    $sign = hash_hmac('sha256', implode('|', $parameters), $cashierApiKey);

                    $parameters['signature'] = $sign;

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_HEADER, 0);
                    curl_setopt($ch, CURLOPT_FAILONERROR, 0);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parameters));
                    $result = trim(curl_exec($ch));
                    curl_close($ch);

                    $response = json_decode($result, true);

                    if ('success' !== $response['type']) {
                        throw new Exception($response['message'] ?? $response['error'] ?? print_r($response, true));
                    }

                    Payments::showLink($response['location']);
                }

                break;

            case 'rb':
                if (empty($cashierSettings->rb_login) || empty($cashierSettings->rb_pass1)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $url = 'https://auth.robokassa.ru/Merchant/Index.aspx';
                $payId = substr($payId, 5);
                $parameters = [
                    'MrchLogin' => $cashierSettings->rb_login,
                    'OutSum' => $amount,
                    'InvId' => $payId,
                    'Desc' => $orderDesc,
                    'SignatureValue' => md5(
                        "{$cashierSettings->rb_login}:{$amount}:{$payId}:{$cashierSettings->rb_pass1}:Shp_zuser=".user()->id
                    ),
                    'Shp_zuser' => user()->id,
                ];

                Payments::showLink($url, $parameters);

                break;

            case 'wb':
                if (empty($cashierSettings->wb_login) || empty($cashierSettings->wb_num)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $url = 'https://merchant.webmoney.ru/lmi/payment.asp';
                $parameters = [
                    'LMI_PAYMENT_NO' => time(),
                    'LMI_PAYMENT_AMOUNT' => $amount,
                    'LMI_PAYMENT_DESC_BASE64' => base64_encode($cashierSettings->wb_login),
                    'LMI_PAYEE_PURSE' => $cashierSettings->wb_num,
                    'id' => user()->id,
                ];
                Payments::showForm($url, $parameters);

                break;

            case 'up':
                if (empty($cashierSettings->up_pass1) || empty($cashierSettings->up_pass2)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $unitPay = new UnitPay(
                    1 == $cashierSettings->up_type ? 'unitpay.money' : 'unitpay.ru',
                    $cashierSettings->up_pass2
                );

                if (2 == $cashierSettings->up_type) {
                    $unitPay->setCustomerEmail(user()->email);
                    $cashItem = new CashItem($orderDesc, 1, $amount);
                    $unitPay->setCashItems([$cashItem]);
                }

                $url = $unitPay->form(
                    $cashierSettings->up_pass1,
                    $amount,
                    user()->id,
                    $orderDesc,
                    Payments::getCashierCurrency('up')
                );

                Payments::showLink($url);

                break;

            case 'ps':
                if (empty($cashierSettings->ps_pass) || empty($cashierSettings->ps_num)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                WebToPay::redirectToPayment(
                    [
                        'projectid' => $cashierSettings->ps_num,
                        'sign_password' => $cashierSettings->ps_pass,
                        'orderid' => $payId,
                        'amount' => $amount * 100,
                        'currency' => $cashierSettings->ps_currency,
                        'accepturl' => $full_site_host.'purse?result_ps=success',
                        'cancelurl' => $full_site_host.'purse?result_ps=fail',
                        'callbackurl' => $full_site_host.'purse?result_ps=get',
                        'test' => $cashierSettings->ps_test,
                        'zzz' => user()->id,
                    ]
                );

                break;

            case 'wo':
                if (empty($cashierSettings->wo_login) || empty($cashierSettings->wo_pass)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $fields = [
                    'WMI_MERCHANT_ID' => $cashierSettings->wo_login,
                    'WMI_PAYMENT_AMOUNT' => $amount * 1.00,
                    'WMI_CURRENCY_ID' => Payments::getCashierCurrency('wo', '643'),
                    'WMI_PAYMENT_NO' => substr($payId, 5),
                    'WMI_DESCRIPTION' => 'BASE64:'.base64_encode($orderDesc),
                    'WMI_SUCCESS_URL' => $full_site_host.'purse?result_wo=success',
                    'WMI_FAIL_URL' => $full_site_host.'purse?result_wo=fail',
                    'user_id' => user()->id,
                ];

                uksort($fields, 'strcasecmp');

                $fieldValues = '';
                foreach ($fields as $value) {
                    $value = iconv('utf-8', 'windows-1251', $value);
                    $fieldValues .= $value;
                }

                $fields['WMI_SIGNATURE'] = base64_encode(pack('H*', md5($fieldValues.$cashierSettings->wo_pass)));
                $url = 'https://wl.walletone.com/checkout/checkout/Index';

                Payments::showForm($url, $fields);

                break;

            case 'qw':
                if (empty($cashierSettings->qw_pass)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $Qiwi = new BillPayments($cashierSettings->qw_pass);

                $data = [
                    'amount' => $amount * 1.00,
                    'currency' => Payments::getCashierCurrency('qw'),
                    'comment' => $orderDesc,
                    'expirationDateTime' => $Qiwi->getLifetimeByDay(1),
                    'email' => user()->email,
                    'account' => user()->id,
                    'successUrl' => $full_site_host.'purse?result_qw=success',
                ];

                $qiwiThemeCode = getConfigAdditional('qiwiThemeCode');
                if ($qiwiThemeCode) {
                    $data['customFields'] = ['themeCode' => $qiwiThemeCode];
                }

                $result = $Qiwi->createBill($Qiwi->generateId(), $data);

                Payments::showLink($result['payUrl']);

                break;

            case 'qw_new':
                if (empty($cashierSettings->qw_new_id) || empty($cashierSettings->qw_new_key)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                global $host;

                Payments::showLink(
                    'https://qiwi.com/payment/form/99',
                    [
                        'blocked' => [
                            'account',
                            'sum',
                        ],
                        'amountFraction' => '0.00',
                        'extra' => [
                            "'account'" => $cashierSettings->qw_new_id,
                            "'comment'" => 'Счет #'.base64_encode($host.':'.(((user()->id * 10000) - 1543) * 13)),
                        ],
                        'amountInteger' => $amount * 1.00,
                        'currency' => Payments::getCashierCurrency('qw_new', '643'),
                    ]
                );

                break;

            case 'lp':
                if (empty($cashierSettings->lp_public_key) || empty($cashierSettings->lp_private_key)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $LiqPay = new LiqPay($cashierSettings->lp_public_key, $cashierSettings->lp_private_key);

                $parameters = $LiqPay->cnb_form_raw(
                    [
                        'public_key' => $cashierSettings->lp_public_key,
                        'amount' => $amount,
                        'version' => '3',
                        'action' => 'pay',
                        'order_id' => $payId,
                        'currency' => Payments::getCashierCurrency('lp'),
                        'description' => $orderDesc,
                        'info' => user()->id,
                        'result_url' => $full_site_host.'purse',
                        'server_url' => $full_site_host.'purse?result_lp=get',
                    ]
                );

                Payments::showForm(
                    $parameters['url'],
                    [
                        'data' => $parameters['data'],
                        'signature' => $parameters['signature'],
                    ]
                );

                break;

            case 'ap':
                if (empty($cashierSettings->ap_project_id) || empty($cashierSettings->ap_private_key)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $url = 'https://anypay.io/merchant';
                $parameters = [
                    'merchant_id' => $cashierSettings->ap_project_id,
                    'pay_id' => $payId,
                    'amount' => $amount,
                    'currency' => Payments::getCashierCurrency('ap'),
                    'desc' => $orderDesc,
                    'user_id' => user()->id,
                ];

                $parameters['sign'] = md5(
                    implode(
                        ':',
                        [
                            $parameters['currency'],
                            $parameters['amount'],
                            $cashierSettings->ap_private_key,
                            $cashierSettings->ap_project_id,
                            $parameters['pay_id'],
                        ]
                    )
                );

                Payments::showForm($url, $parameters);

                break;

            case 'enot':
                if (
                    empty($cashierSettings->enot_id)
                    || empty($cashierSettings->enot_key)
                    || empty($cashierSettings->enot_key2)
                ) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $url = getConfigAdditional('enotUrl', 'https://enot.io/pay');

                $parameters = [
                    'm' => $cashierSettings->enot_id,
                    'oa' => $amount,
                    'o' => $payId,
                    'cr' => Payments::getCashierCurrency('enot'),
                    'c' => $orderDesc,
                    'cf' => user()->id,
                    's' => md5(
                        $cashierSettings->enot_id.':'.$amount.':'.$cashierSettings->enot_key.':'.$payId
                    ),
                ];

                Payments::showForm($url, $parameters);

                break;

            case 'payanyway':
                if (
                    empty($cashierSettings->payanyway_id)
                    || empty($cashierSettings->payanyway_code)
                ) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $monetaSDK = new MonetaSdk(__DIR__.'/../inc/classes/PayAnyWay/config/');
                $monetaSDK->setSettingValue('monetasdk_account_id', $cashierSettings->payanyway_id);
                $monetaSDK->setSettingValue('monetasdk_account_code', $cashierSettings->payanyway_code);
                $monetaSDK->setSettingValue('monetasdk_connection_type', 'json');
                $monetaSDK->setSettingValue('monetasdk_success_url', $full_site_host.'purse/success');
                $monetaSDK->setSettingValue('monetasdk_fail_url', $full_site_host.'purse/fail');
                $monetaSDK->setSettingValue('monetasdk_inprogress_url', $full_site_host.'purse');
                $monetaSDK->setSettingValue('monetasdk_return_url', $full_site_host.'purse');

                $monetaSDK->processCleanChoosenPaymentSystem();
                $result = $monetaSDK->showPaymentFrom(
                    $payId,
                    $amount,
                    Payments::getCashierCurrency('payanyway'),
                    $orderDesc,
                    false,
                    null,
                    false,
                    ['user_id' => user()->id, 'autoSubmit' => true],
                    'POST'
                );

                echo $result->render;

                break;

            case 'yookassa':
                if (
                    empty($cashierSettings->yookassa_id)
                    || empty($cashierSettings->yookassa_key)
                ) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $currency = Payments::getCashierCurrency('yookassa');

                $client = new Client();
                $client->setAuth($cashierSettings->yookassa_id, $cashierSettings->yookassa_key);
                $payment = $client->createPayment(
                    [
                        'amount' => [
                            'value' => $amount,
                            'currency' => $currency,
                        ],
                        'confirmation' => [
                            'type' => 'redirect',
                            'return_url' => $full_site_host.'purse',
                        ],
                        'capture' => true,
                        'description' => $orderDesc,
                        'metadata' => [
                            'user_id' => user()->id,
                        ],
                        'receipt' => [
                            'customer' => [
                                'email' => user()->email,
                            ],
                            'items' => [
                                [
                                    'description' => $orderDesc,
                                    'quantity' => '1.00',
                                    'amount' => [
                                        'value' => $amount,
                                        'currency' => $currency,
                                    ],
                                    'vat_code' => getConfigAdditional('yookassaVatCode', '1'),
                                    'payment_mode' => 'full_payment',
                                    'payment_subject' => 'commodity',
                                ],
                            ],
                        ],
                    ],
                    $payId
                );

                Payments::showLink($payment->confirmation->confirmation_url);

                break;

            case 'paypalych':
                if (
                    empty($cashierSettings->paypalych_id)
                    || empty($cashierSettings->paypalych_key)
                ) {
                    throw new Exception('Способ оплаты не настроен');
                }

                if ($amount < 20) {
                    throw new Exception('Не менее '. 20 .$messages['RUB']);
                }

                $curl = new Curl();
                $curl->setHeader('Authorization', 'Bearer '.$cashierSettings->paypalych_key);

                $curl->post('https://pal24.pro/api/v1/bill/create', [
                    'shop_id' => $cashierSettings->paypalych_id,
                    'amount' => $amount * 1.00,
                    'description' => $orderDesc,
                    'custom' => user()->id,
                    'currency_in' => Payments::getCashierCurrency('paypalych'),
                    'payer_pays_commission' => 1,
                    'order_id' => $payId,
                    'name' => $orderDesc,
                    'success_url' => $full_site_host.'purse/success',
                    'fail_url' => $full_site_host.'purse/fail',
                ]);

                $response = json_decode($curl->rawResponse, true);

                if (empty($response['link_page_url'])) {
                    throw new Exception($response['message']);
                }

                Payments::showLink($response['link_page_url']);

                break;

            case 'primepayments':
                if (
                    empty($cashierSettings->primepayments_id)
                    || empty($cashierSettings->primepayments_key)
                    || empty($cashierSettings->primepayments_key_2)
                ) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $data = [
                    'action' => 'initPayment',
                    'project' => $cashierSettings->primepayments_id,
                    'sum' => $amount,
                    'currency' => Payments::getCashierCurrency('primepayments'),
                    'innerID' => user()->id,
                    'email' => user()->email,
                    'comment' => $orderDesc,
                    'payWay' => '1',
                ];

                $data['sign'] = md5(
                    $cashierSettings->primepayments_key
                    .$data['action']
                    .$data['project']
                    .$data['sum']
                    .$data['currency']
                    .$data['innerID']
                    .$data['email']
                    .$data['payWay']
                );

                $curl = new Curl();
                $curl->post('https://pay.primepayments.io/API/v2/', $data);
                $response = json_decode($curl->rawResponse, true);

                if ('OK' != $response['status']) {
                    throw new Exception($response['result']);
                }

                Payments::showLink($response['result']);

                break;

            case 'lava':
                if (
                    empty($cashierSettings->lava_id)
                    || empty($cashierSettings->lava_key)
                    || empty($cashierSettings->lava_key_2)
                ) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $data = json_encode(
                    [
                        'sum' => $amount,
                        'orderId' => $payId,
                        'shopId' => $cashierSettings->lava_id,
                        'customFields' => user()->id,
                        'comment' => $orderDesc,
                    ],
                    JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE
                );
                $signature = hash_hmac('sha256', $data, $cashierSettings->lava_key);

                $curl = new Curl();
                $curl->setHeader('Accept', 'application/json');
                $curl->setHeader('Content-Type', 'application/json');
                $curl->setHeader('Signature', $signature);
                $curl->post('https://api.lava.ru/business/invoice/create', $data);
                $response = json_decode($curl->rawResponse, true);

                if ('200' != $response['status']) {
                    throw new Exception(json_encode($response['error']));
                }

                Payments::showLink($response['data']['url']);

                break;

            case 'foxypay':
                if (empty($cashierSettings->foxypay_token)) {
                    throw new Exception('Способ оплаты не настроен');
                }

                $data = [
                    'amount' => $amount * 100,
                    'description' => $orderDesc,
                    'webhook_url' => $full_site_host.'purse?foxypay=pay',
                    'success_url' => $full_site_host.'purse/success',
                    'fail_url' => $full_site_host.'purse/fail',
                    'info' => user()->id,
                ];

                $curl = new Curl();
                $curl->setHeader('token', $cashierSettings->foxypay_token);
                $curl->post('https://foxypay.net/api/payment', $data);
                $response = json_decode($curl->rawResponse, true);
                if (false === $response['success']) {
                    throw new Exception($response['err']);
                }

                Payments::showLink($response['redirect_url']);

                break;
        }

        ?>
		<script>
          NProgress.done();
          setTimeout(show_ok, 500);
		</script>
		<?php
    } catch (Exception $e) {
        ?>
		<script>
          show_input_error(
            'number_<?php echo $cashierSlug; ?>',
            '<?php echo $e->getMessage(); ?>'
          );
          NProgress.done();
          setTimeout(show_error, 500);
		</script>
		<?php
    }

    exit;
}
if (isset($_POST['get_operations'])) {
    if (array_key_exists('page', $_POST)) {
        $page = check($_POST['page'], 'int');
    }

    if (empty($page)) {
        $page = 1;
    }

    $limit = 10;
    $start = ($page - 1) * $limit;
    $globalRowNum = $start;
    $localRowNum = 0;

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $STH = pdo()->prepare(
        'SELECT 
					    `money__actions`.*, 
					    `money__actions_types`.`name`, 
					    `money__actions_types`.`class` 
					FROM 
					    `money__actions` 
						INNER JOIN 
						        `money__actions_types` 
						            ON 
						                `money__actions_types`.`id` = `money__actions`.`type`
					WHERE 
					    `money__actions`.`author`=:author 
					ORDER BY `money__actions`.`date` DESC LIMIT '.$start.', '.$limit
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':author' => $_SESSION['id']]);
    while ($row = $STH->fetch()) {
        ++$globalRowNum;
        ++$localRowNum;

        $tpl->load_template('elements/money_action.tpl');
        $tpl->set('{shilings}', $row->shilings);
        $tpl->set('{type}', collect_consumption_str(1, $row->type, $row->class, $row->name, pdo(), $row->gave_out));
        $tpl->set('{date}', expand_date($row->date, 7));
        $tpl->compile('content');
        $tpl->clear();
    }
    if (0 == $globalRowNum) {
        $tpl->result['content'] = tableRowError('<span class="empty-element">Пусто</span>');
    } elseif ($localRowNum > $limit - 1) {
        ++$page;
        $tpl->result['content'] .= '<tr id="loader'.$page.'" class="c-p" onclick="get_operations(\''.$page.'\');"><td colspan="10">Подгрузить записи</td></tr>';
    }
    $tpl->show($tpl->result['content']);
    $tpl->global_clear();

    exit;
}
if (isset($_POST['buy_service'])) {
    ignore_user_abort(1);
    set_time_limit(getTimeLimit());

    $server = check($_POST['server'], 'int');
    $service = check($_POST['service'], 'int');
    $tarif = check($_POST['tarifs'], 'int');
    $type = check($_POST['type'], 'int');
    $nick = check($_POST['nick'], null);
    $pass = check($_POST['pass'], null);
    $steam_id = check($_POST['steam_id'], null);
    $check1 = check($_POST['check1'], 'int');
    $check2 = check($_POST['check2'], 'int');

    if (empty($check1)) {
        $check1 = 0;
    }
    if (empty($check2)) {
        $check2 = 0;
    }

    if (1 == configs()->cont) {
        $STH = pdo()->query("SELECT `vk` FROM `users` WHERE `id`='{$_SESSION['id']}' LIMIT 1");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        if (empty($row->vk)) {
            exit(
                json_encode(
                    [
                        'status' => '3',
                        'data' => 'Укажите свой аккаунт Вконтакте в <a href="../settings" target="_blank">профиле</a>',
                    ]
                )
            );
        }
    }

    if (empty($server) or empty($service) or empty($tarif) or empty($type)) {
        exit(json_encode(['status' => '3', 'data' => 'Заполните все поля!']));
    }

    $STH = pdo()->query(
        "SELECT id,type,ip,port,name,pass_prifix,discount,binds FROM servers WHERE id='{$server}' LIMIT 1"
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $server = $STH->fetch();
    if (empty($server->id)) {
        exit(json_encode(['status' => '3', 'data' => 'Данного сервера не существует']));
    }
    if (empty($server->type)) {
        exit(json_encode(['status' => '3', 'data' => 'Невозможно подключение к FTP и базе игрового сервера']));
    }
    $server->address = $server->ip.':'.$server->port;
    $binds = explode(';', $server->binds);

    if ('1' != $type and '2' != $type and '3' != $type) {
        exit(json_encode(['status' => '3', 'data' => 'Неверно указан тип!']));
    }

    if ((0 == $binds[0] and 1 == $type) || (0 == $binds[1] and 2 == $type) || (0 == $binds[2] and 3 == $type)) {
        exit(json_encode(['status' => '3', 'data' => 'Данный тип запрещен!']));
    }

    $SIDO = new SteamIDOperations();

    if ('1' == $type) {
        $admin['type'] = 'a';
        if (empty($nick)) {
            exit(json_encode(['status' => '2', 'input' => 'player_nick', 'reply' => 'Заполните!']));
        }
        if (mb_strlen($_POST['nick'], 'UTF-8') > 32) {
            exit(json_encode(['status' => '2', 'input' => 'player_nick', 'reply' => 'Не более 32 символов!']));
        }
        if (empty($pass)) {
            exit(json_encode(['status' => '2', 'input' => 'player_pass', 'reply' => 'Заполните!']));
        }
        if (mb_strlen($pass, 'UTF-8') > 32) {
            exit(json_encode(['status' => '2', 'input' => 'player_pass', 'reply' => 'Не более 32 символов!']));
        }
        $admin['name'] = $nick;
        $admin['pass'] = $pass;
        $admin['pass_md5'] = md5($pass);
    }
    if ('2' == $type) {
        $admin['type'] = 'ce';
        if (empty($steam_id)) {
            exit(json_encode(['status' => '2', 'input' => 'player_steam_id', 'reply' => 'Заполните!']));
        }
        if (mb_strlen($steam_id, 'UTF-8') > 32) {
            exit(json_encode(['status' => '2', 'input' => 'player_steam_id', 'reply' => 'Не более 32 символов!']));
        }
        if (!$steam_id = $SIDO->GetSteamID32($steam_id)) {
            exit(json_encode(['status' => '2', 'input' => 'player_steam_id', 'reply' => 'Неверный STEAM ID!']));
        }
        $admin['name'] = $steam_id;
        $admin['pass'] = '';
        $admin['pass_md5'] = '';
    }
    if ('3' == $type) {
        $admin['type'] = 'ca';
        if (empty($steam_id)) {
            exit(json_encode(['status' => '2', 'input' => 'player_steam_id', 'reply' => 'Заполните!']));
        }
        if (mb_strlen($steam_id, 'UTF-8') > 32) {
            exit(json_encode(['status' => '2', 'input' => 'player_steam_id', 'reply' => 'Не более 32 символов!']));
        }
        if (!$steam_id = $SIDO->GetSteamID32($steam_id)) {
            exit(json_encode(['status' => '2', 'input' => 'player_steam_id', 'reply' => 'Неверный STEAM ID!']));
        }
        if (empty($pass)) {
            exit(json_encode(['status' => '2', 'input' => 'player_pass', 'reply' => 'Заполните!']));
        }
        if (mb_strlen($pass, 'UTF-8') > 32) {
            exit(json_encode(['status' => '2', 'input' => 'player_pass', 'reply' => 'Не более 32 символов!']));
        }
        $admin['name'] = $steam_id;
        $admin['pass'] = $pass;
        $admin['pass_md5'] = md5($pass);
    }

    $adminsService = new AdminsService();
    if (!check_for_bad_nicks($admin['name'])) {
        exit(json_encode(['status' => '3', 'data' => 'Использовать данный идентификатор запрещено!']));
    }

    if ('ce' == $admin['type'] || 'ca' == $admin['type']) {
        $STH = pdo()->prepare(
            prepareSearchQuery(
                'SELECT id,user_id,active,pause,name FROM admins WHERE name LIKE :name AND server=:server LIMIT 1'
            )
        );

        $adminNameForCheck = '%'.strip_data(':'.explode(':', $admin['name'])[2]);
    } else {
        $STH = pdo()->prepare(
            'SELECT id,user_id,active,pause,name FROM admins WHERE name=:name AND server=:server LIMIT 1'
        );

        $adminNameForCheck = $admin['name'];
    }

    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':name' => $adminNameForCheck, ':server' => $server->id]);
    $row = $STH->fetch();
    if (isset($row->id)) {
        if ($row->user_id == $_SESSION['id'] && $row->name == $admin['name']) {
            if (0 == $check1) {
                exit(json_encode(['status' => '4']));
            }
        } else {
            exit(json_encode(['status' => '3', 'data' => 'На сервере уже имеется администратор с такими данными!']));
        }

        if (2 == $row->active) {
            exit(json_encode(['status' => '3', 'data' => 'Данный аккаунт заблокирован!']));
        }

        if (0 != $row->pause) {
            exit(json_encode(['status' => '3', 'data' => 'Данный аккаунт приостановлен!']));
        }

        $admin['id'] = $row->id;
        $admin['has_rights'] = 1;
    } else {
        $admin['has_rights'] = 0;
    }

    $STH = pdo()->query("SELECT * FROM services WHERE id='{$service}' and server='{$server->id}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $service = $STH->fetch();
    if (empty($service->id)) {
        exit(json_encode(['status' => '3', 'data' => 'Услуга не найдена']));
    }
    if (2 == $service->sale) {
        exit(json_encode(['status' => '3', 'data' => 'Услуга не продается']));
    }
    if (0 != $service->users_group) {
        if (0 == $check2) {
            $STH = pdo()->prepare('SELECT name FROM users__groups WHERE id=:id LIMIT 1');
            $STH->setFetchMode(PDO::FETCH_OBJ);
            $STH->execute([':id' => $service->users_group]);
            $row = $STH->fetch();

            exit(json_encode(['status' => '5', 'group' => $row->name]));
        }
    }

    if (isset($admin['id'])) {
        $STH = pdo()->prepare('SELECT id FROM admins__services WHERE service=:service AND admin_id=:admin_id LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':service' => $service->id, ':admin_id' => $admin['id']]);
        $row = $STH->fetch();
        if (isset($row->id)) {
            exit(
                json_encode(
                    [
                        'status' => '3',
                        'data' => 'У Вас уже имеется данная услуга. Если Вы хотите её продлить, перейдите в раздел <a href="../my_stores" target="_blank">Мои услуги</a>',
                    ]
                )
            );
        }
    }

    $STH = pdo()->query(
        "SELECT id,price,time,discount FROM services__tarifs WHERE id='{$tarif}' and service='{$service->id}' LIMIT 1"
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $tarif = $STH->fetch();
    if (empty($tarif->id)) {
        exit(json_encode(['status' => '3', 'data' => 'Тариф не найден']));
    }

    $STH = pdo()->query('SELECT discount FROM config__prices LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();

    $proc = calculate_discount(
        $server->discount,
        $row->discount,
        user()->proc,
        $service->discount,
        $tarif->discount
    );
    $price = calculate_price($tarif->price, $proc);
    $admin['irretrievable'] = calculate_return($price, $tarif->time);

    $STH = pdo()->query("SELECT id,shilings FROM users WHERE id='{$_SESSION['id']}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit(json_encode(['status' => '3', 'data' => 'Пользователь не найден']));
    }
    if ($row->shilings < $price) {
        $price_delta = round_shilings($price - $row->shilings);

        exit(
            json_encode(
                [
                    'status' => '3',
                    'data' => 'У Вас недостаточно средств <span class="m-icon icon-bank"></span><br><a href="../purse?price='.$price_delta.'">Пополните баланс на '.$price_delta.$messages['RUB'].'.</a>',
                ]
            )
        );
    }
    $shilings = round_shilings($row->shilings - $price);

    if (Integrations::SOURCEBANS == $server->type) {
        $STH = pdo()->query("SELECT nick FROM users WHERE id='{$_SESSION['id']}' LIMIT 1");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        if (empty($row->nick)) {
            exit(
                json_encode(
                    [
                        'status' => '3',
                        'data' => 'Заполните в своем <a href="../settings" target="_blank">профиле</a> поле ник',
                    ]
                )
            );
        }

        if (1 == $admin['has_rights']) {
            if ('' != $service->sb_group) {
                $STH = pdo()->query(
                    "SELECT `admins__services`.`id` FROM `admins__services` LEFT JOIN `services` ON `admins__services`.`service` = `services`.`id` WHERE `services`.`sb_group`!='' AND `admins__services`.`admin_id` = '{$admin['id']}' LIMIT 1"
                );
                $STH->setFetchMode(PDO::FETCH_OBJ);
                $row = $STH->fetch();
                if (isset($row->id)) {
                    exit(json_encode(['status' => '3', 'data' => 'Данные услуги объединить невозможно!']));
                }
            }
        }
    }

    if (1 == $server->type || 3 == $server->type) {
        if (false !== stristr(htmlspecialchars_decode($admin['name'], ENT_QUOTES), '"')) {
            exit(json_encode(['status' => '3', 'data' => 'Ваш идентификатор содержит запрещенный символ: "']));
        }
        if (false !== stristr(htmlspecialchars_decode($admin['name'], ENT_QUOTES), '#')) {
            exit(json_encode(['status' => '3', 'data' => 'Ваш идентификатор содержит запрещенный символ: #']));
        }

        if (false !== stristr(htmlspecialchars_decode($admin['pass'], ENT_QUOTES), '"')) {
            exit(json_encode(['status' => '3', 'data' => 'Ваш пароль содержит запрещенный символ: "']));
        }
        if (false !== stristr(htmlspecialchars_decode($admin['pass'], ENT_QUOTES), '#')) {
            exit(json_encode(['status' => '3', 'data' => 'Ваш пароль содержит запрещенный символ: #']));
        }
    }

    $adminsService = new AdminsService();
    [$isSuccess, $error] = $adminsService->isIntegratorStorageAvailable($server->id);
    if (!$isSuccess) {
        exit(json_encode(['status' => '3', 'data' => (string) $error]));
    }

    $admin['ending_date'] = add_days($tarif->time);
    $admin['bought_date'] = date('Y-m-d H:i:s');
    $admin['service_time'] = $tarif->id;
    $admin['service'] = $service->id;

    if (1 == $admin['has_rights']) {
        $STH = pdo()->prepare(
            'UPDATE admins SET name=:name, pass=:pass, pass_md5=:pass_md5, type=:type WHERE id=:id LIMIT 1'
        );
        if (
            '1' == !$STH->execute(
                [
                    'name' => $admin['name'],
                    'pass' => $admin['pass'],
                    'pass_md5' => $admin['pass_md5'],
                    'type' => $admin['type'],
                    'id' => $admin['id'],
                ]
            )
        ) {
            exit(json_encode(['status' => '3', 'data' => 'Ошибка записи админа в базу данных.']));
        }
    } else {
        $STH = pdo()->prepare(
            'INSERT INTO admins (name,pass,pass_md5,type,server,user_id) VALUES (:name, :pass, :pass_md5, :type, :server, :user_id)'
        );
        if (
            '1' == !$STH->execute(
                [
                    'name' => $admin['name'],
                    'pass' => $admin['pass'],
                    'pass_md5' => $admin['pass_md5'],
                    'type' => $admin['type'],
                    'server' => $server->id,
                    'user_id' => $_SESSION['id'],
                ]
            )
        ) {
            exit(json_encode(['status' => '3', 'data' => 'Ошибка записи админа в базу данных.']));
        }
    }

    if (empty($admin['id'])) {
        $STH = pdo()->prepare('SELECT id FROM admins WHERE name=:name AND server=:server LIMIT 1');
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':name' => $admin['name'], ':server' => $server->id]);
        $row = $STH->fetch();
        $admin['id'] = $row->id;
    }

    if (0 != $service->users_group and 1 == $check2) {
        $STH = pdo()->prepare(
            "SELECT admins__services.previous_group FROM admins__services 
			LEFT JOIN admins ON admins.id = admins__services.admin_id WHERE admins.user_id=:user_id AND admins__services.previous_group!='0' LIMIT 1"
        );
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':user_id' => $_SESSION['id']]);
        $row = $STH->fetch();

        if (isset($row->previous_group)) {
            $admin['previous_group'] = $row->previous_group;
        } else {
            $admin['previous_group'] = $_SESSION['rights'];
        }
    } else {
        $admin['previous_group'] = 0;
    }

    $STH = pdo()->prepare(
        'INSERT INTO admins__services (admin_id,service,service_time,bought_date,ending_date,irretrievable,previous_group) VALUES (:admin_id, :service, :service_time, :bought_date, :ending_date, :irretrievable, :previous_group)'
    );
    if (
        '1' == !$STH->execute(
            [
                ':admin_id' => $admin['id'],
                ':service' => $admin['service'],
                ':service_time' => $admin['service_time'],
                ':bought_date' => $admin['bought_date'],
                ':ending_date' => $admin['ending_date'],
                ':irretrievable' => $admin['irretrievable'],
                ':previous_group' => $admin['previous_group'],
            ]
        )
    ) {
        exit(json_encode(['status' => '3', 'data' => 'Ошибка записи прав в базу данных.']));
    }

    [$isSuccess, $error] = $adminsService->syncAdminWithIntegratorStorage($admin['id']);
    if (!$isSuccess) {
        log_error("buy_service: {$error}");

        exit(json_encode(['status' => '3', 'data' => 'Не удалось экспортировать администратора на игровой сервер']));
    }

    if (0 != $service->users_group and 1 == $check2) {
        $STH = pdo()->prepare('UPDATE users SET shilings=:shilings, rights=:rights WHERE id=:id LIMIT 1');
        $STH->execute([':shilings' => $shilings, ':rights' => $service->users_group, ':id' => $_SESSION['id']]);
    } else {
        $STH = pdo()->prepare('UPDATE users SET shilings=:shilings WHERE id=:id LIMIT 1');
        $STH->execute([':shilings' => $shilings, ':id' => $_SESSION['id']]);
    }

    $STH = pdo()->prepare(
        'INSERT INTO money__actions (date,shilings,author,type) VALUES (:date, :shilings, :author, :type)'
    );
    $STH->execute(['date' => date('Y-m-d H:i:s'), 'shilings' => -$price, 'author' => $_SESSION['id'], 'type' => '2']);

    incNotifications();
    $noty = success_buy_noty(
        $admin['name'],
        $admin['pass'],
        $tarif->time,
        $admin['ending_date'],
        $server->name,
        $server->address,
        $service->name,
        $server->pass_prifix
    );
    send_noty($noty, $_SESSION['id'], 2);
    $full_mess = $noty;
    $noty = success_buy_noty_for_admin(
        $_SESSION['id'],
        $_SESSION['login'],
        $tarif->time,
        $admin['ending_date'],
        $server->name,
        $server->address,
        $service->name
    );
    send_noty($noty, 0, 2);

    if (0 == $tarif->time) {
        $tarif->time = 'Навсегда';
    } else {
        $tarif->time = $tarif->time.' суток';
    }

    service_log(
        'Куплены права - '.$service->name.' ('.$tarif->time.')',
        $admin['id'],
        $server->id,
        $service->id
    );

    exit(
        json_encode(
            [
                'status' => '1',
                'data' => '<h4>Услуга успешно приобретена!</h4><div>'.$full_mess.'</div>',
                'shilings' => $shilings,
            ]
        )
    );
}
if (isset($_POST['buy_unban'])) {
    $serverId = check($_POST['server'], 'int');
    $id = check($_POST['id'], 'int');

    if (empty($serverId) or empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $prices = pdo()->query('SELECT * FROM config__prices')->fetchObject();

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $bansService = new BansService();
    $integrator = $bansService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    $table = set_prefix($server->db_prefix, 'bans');

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $ban = $connection
            ->query("SELECT * FROM {$table} WHERE bid = '{$id}'")
            ->fetchObject();
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $table = set_prefix($server->db_prefix, 'bans');

        $ban = $connection
            ->query(
                "SELECT 
					{$table}.bid,
				    {$table}.RemoveType AS expired,
				    {$table}.authid AS player_id,
				    {$table}.name AS player_nick,
				    {$table}.created AS ban_created,
				    {$table}.length AS ban_length,
				    {$table}.reason AS ban_reason,
				    {$table}.unban_type
				FROM 
					{$table} 
				WHERE {$table}.bid = '{$id}'"
            )
            ->fetchObject();
    }

    if (Integrations::IKS == $server->type) {
        $table = set_prefix($server->db_prefix, 'bans');

        $ban = $connection
            ->query(
                "SELECT 
					{$table}.id as bid,
				    {$table}.Unbanned AS expired,
				    {$table}.sid AS player_id,
				    {$table}.name AS player_nick,
				    {$table}.created AS ban_created,
				    {$table}.time AS ban_length,
				    {$table}.reason AS ban_reason,
				    {$table}.unban_type
				FROM 
					{$table} 
				WHERE {$table}.id = '{$id}'"
            )
            ->fetchObject();
    }

    if (empty($ban->bid)) {
        exit(json_encode(['status' => '2', 'info' => 'Бан не найден']));
    }

    $ban_nick = check($ban->player_nick, null);
    $ban_steamid = $ban->player_id;
    $ban_id = $ban->bid;
    $ban_length = $ban->ban_length;

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $ban_length *= 60;
    }

    if (Integrations::SOURCEBANS == $server->type) {
    }

    if (Integrations::IKS == $server->type) {
        $ban_steamid = (new SteamIDOperations())->GetSteamID32($ban_steamid);
    }

    $ban_end = $ban->ban_created + $ban_length;

    if (
        ($ban_end < time() && 0 != $ban_length)
        || 1 == $ban->expired
        || 'E' == $ban->expired
        || 'U' == $ban->expired
        || in_array($ban->unban_type, [-2, -1, 1])
    ) {
        exit(json_encode(['status' => '2', 'info' => 'Бан неактивен']));
    }

    if (0 == $ban_length) {
        $price = $prices->price3;
    } else {
        if (($ban_end - time()) < 60 * 60 * 24 * 7) {
            $price = $prices->price1;
        } else {
            $price = $prices->price2;
        }
    }

    if (!$price) {
        exit(json_encode(['status' => '2', 'info' => 'Покупка разблокировки невозможна!']));
    }

    if (user()->shilings < $price) {
        exit(json_encode(['status' => '2', 'info' => 'У Вас недостаточно средств!']));
    }

    $shilings = round_shilings(user()->shilings - $price);

    $table = set_prefix($server->db_prefix, 'bans');

    if (
        Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $connection
            ->prepare("UPDATE {$table} SET `expired`=:expired, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1")
            ->execute([':expired' => '1', ':unban_type' => '-2', ':ban_closed' => $_SESSION['id'], ':id' => $ban_id]);
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $connection
            ->prepare("UPDATE {$table} SET `RemovedBy`=:RemovedBy,`RemoveType`=:RemoveType, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1")
            ->execute(
                [
                    ':RemovedBy' => '0',
                    ':RemoveType' => 'U',
                    ':unban_type' => '-2',
                    ':ban_closed' => $_SESSION['id'],
                    ':id' => $ban_id,
                ]
            );
    }

    if (Integrations::IKS == $server->type) {
        $connection
            ->prepare("UPDATE {$table} SET `Unbanned`=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1")
            ->execute(
                [
                    ':Unbanned' => '1',
                    ':unban_type' => '-2',
                    ':ban_closed' => $_SESSION['id'],
                    ':id' => $ban_id,
                ]
            );
    }

    pdo()
        ->prepare('UPDATE users SET shilings=:shilings WHERE id=:id LIMIT 1')
        ->execute([':shilings' => $shilings, ':id' => user()->id]);

    pdo()
        ->prepare('INSERT INTO money__actions (date,shilings,author,type) VALUES (:date, :shilings, :author, :type)')
        ->execute(['date' => date('Y-m-d H:i:s'), 'shilings' => -$price, 'author' => user()->id, 'type' => '4']);

    incNotifications();
    $noty = success_buy_unban_noty($ban_nick, $ban_steamid, $ban_id);
    send_noty($noty, $_SESSION['id'], 2);

    $noty = success_buy_unban_noty_for_admin(
        $_SESSION['id'],
        $_SESSION['login'],
        $ban_nick,
        $ban_steamid,
        $ban_id
    );
    send_noty($noty, 0, 2);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['buy_stickers'])) {
    $STH = pdo()->query('SELECT price4 FROM config__prices LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $price = $STH->fetch();
    $price = $price->price4;

    $user = $_SESSION['id'];
    $STH = pdo()->query("SELECT id,shilings,stickers FROM users WHERE id='{$user}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit(json_encode(['status' => '2']));
    }
    if (1 == $row->stickers) {
        $result = ['status' => '2', 'info' => 'У Вас уже куплены стикеры!'];

        exit(json_encode($result));
    }
    if ($row->shilings < $price) {
        $result = ['status' => '2', 'info' => 'У Вас недостаточно средств!'];

        exit(json_encode($result));
    }
    $shilings = round_shilings($row->shilings - $price);
    $stickers = 1;

    $STH = pdo()->prepare("UPDATE users SET shilings=:shilings,stickers=:stickers WHERE id='{$user}' LIMIT 1");
    $STH->execute(['shilings' => $shilings, 'stickers' => 1]);

    $STH = pdo()->prepare(
        'INSERT INTO money__actions (date,shilings,author,type) VALUES (:date, :shilings, :author, :type)'
    );
    $STH->execute(['date' => date('Y-m-d H:i:s'), 'shilings' => -$price, 'author' => $user, 'type' => '5']);
    $_SESSION['stickers'] = 1;

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['activate_voucher'])) {
    $voucher_key = check($_POST['voucher_key'], null);
    if (empty($voucher_key)) {
        exit('<p class="text-danger">Вы не ввели ваучер</p>');
    }
    $STH = pdo()->prepare('SELECT id,val,status FROM vouchers WHERE `key`=:key LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':key' => $voucher_key]);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit('<p class="text-danger">Ваучера не существует</p>');
    }
    if (0 != $row->status) {
        exit('<p class="text-danger">Ваучер уже активирован</p>');
    }

    $sum = $row->val;
    $voucher_id = $row->id;
    $user_id = $_SESSION['id'];

    $STH = pdo()->query("SELECT id,shilings FROM users WHERE id='{$user_id}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit('<p class="text-danger">Неверный ID пользователя</p>');
    }
    $shilings = round_shilings($row->shilings + $sum);
    $STH = pdo()->prepare("UPDATE users SET shilings=:shilings WHERE id='{$user_id}' LIMIT 1");
    $STH->execute(['shilings' => $shilings]);

    $STH = pdo()->prepare("UPDATE vouchers SET status=:status WHERE id='{$voucher_id}' LIMIT 1");
    $STH->execute(['status' => $user_id]);

    $STH = pdo()->prepare(
        'INSERT INTO money__actions (date,shilings,author,type) VALUES (:date, :shilings, :author, :type)'
    );
    $STH->execute(['date' => date('Y-m-d H:i:s'), 'shilings' => $sum, 'author' => $user_id, 'type' => '8']);

    incNotifications();
    $noty = successful_activation_voucher_for_admin($user_id, $_SESSION['login'], $sum, $voucher_key);
    send_noty($noty, 0, 2);

    $noty = successful_activation_voucher($sum);
    send_noty($noty, $_SESSION['id'], 2);

    write_log('Активирован ваучер на сумму '.$sum.$messages['RUB']);

    exit('<div class="bs-callout bs-callout-success mt-10"><h4>Ваучер успешно активирован</h4>'.$noty.'</div><script>$("#balance").empty();$("#balance").append("'.$shilings.'");$("#my_balance").empty();$("#my_balance").append("'.$shilings.'");$("#voucher_key").val("");</script>');
}
if (isset($_POST['buy_unmute'])) {
    $serverId = check($_POST['server'], 'int');
    $id = check($_POST['id'], 'int');

    if (empty($serverId) or empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $prices = pdo()->query('SELECT * FROM config__prices')->fetchObject();

    $server = ServerRepository::getById($serverId);
    if (empty($server)) {
        exit(json_encode(['status' => '2']));
    }

    $mutesService = new MutesService();
    $integrator = $mutesService->getIntegrator($server->type);
    if ($integrator->isBlank()) {
        exit(json_encode(['status' => '2']));
    }

    [$connection, $error] = $integrator->getStorageConnection($server);
    if ($error) {
        exit(json_encode(['status' => '2']));
    }

    if (
        Integrations::USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $table = 'comms';

        if (!check_table($table, $connection)) {
            exit(json_encode(['status' => 2]));
        }

        $ban = $connection
            ->query(
                "SELECT 
						0 as expired,
						{$table}.bid,
					    {$table}.expired AS unban_type,
					    {$table}.authid AS player_id,
					    {$table}.name AS player_nick,
					    {$table}.created AS ban_created,
					    {$table}.length AS ban_length,
					    {$table}.reason AS ban_reason 
					FROM {$table} 
					WHERE {$table}.bid = '{$id}'"
            )
            ->fetchObject();
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $table = set_prefix($server->db_prefix, 'comms');

        if (!check_table($table, $connection)) {
            exit(json_encode(['status' => 2]));
        }

        $ban = $connection
            ->query(
                "SELECT 
						{$table}.bid,
					    {$table}.RemoveType AS expired,
					    {$table}.authid AS player_id,
					    {$table}.name AS player_nick,
					    {$table}.created AS ban_created,
					    {$table}.length AS ban_length,
					    {$table}.reason AS ban_reason,
				    	{$table}.unban_type
					FROM {$table} 
					WHERE {$table}.bid = '{$id}'"
            )
            ->fetchObject();
    }

    if (Integrations::IKS == $server->type) {
        $table = set_prefix($server->db_prefix, 'mutes');

        if (!check_table($table, $connection)) {
            exit(json_encode(['status' => 2]));
        }

        $ban = $connection
            ->query(
                "SELECT 
					{$table}.id as bid,
				    {$table}.Unbanned AS expired,
				    {$table}.sid AS player_id,
				    {$table}.name AS player_nick,
				    {$table}.created AS ban_created,
				    {$table}.time AS ban_length,
				    {$table}.reason AS ban_reason,
				    {$table}.unban_type
				FROM 
					{$table} 
				WHERE {$table}.id = '{$id}'"
            )
            ->fetchObject();
    }

    if (empty($ban->bid)) {
        exit(json_encode(['status' => '2', 'info' => 'Мут не найден']));
    }

    $ban_nick = check($ban->player_nick, null);
    $ban_steamid = $ban->player_id;
    $ban_id = $ban->bid;
    $ban_length = $ban->ban_length;

    if (
        Integrations::USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $ban_length *= 60;
    }

    if (Integrations::SOURCEBANS == $server->type) {
    }

    if (Integrations::IKS == $server->type) {
        $ban_steamid = (new SteamIDOperations())->GetSteamID32($ban_steamid);
    }

    $ban_end = $ban->ban_created + $ban_length;

    if (
        ($ban_end < time() && 0 != $ban_length)
        || 1 == $ban->expired
        || 'E' == $ban->expired
        || 'U' == $ban->expired
        || in_array($ban->unban_type, [-2, -1, 1])
    ) {
        exit(json_encode(['status' => '2', 'info' => 'Мут неактивен']));
    }

    if (0 == $ban_length) {
        $price = $prices->price2_3;
    } else {
        if (($ban_end - time()) < 60 * 60 * 24 * 7) {
            $price = $prices->price2_1;
        } else {
            $price = $prices->price2_2;
        }
    }

    if (0 == $price) {
        exit(json_encode(['status' => '2', 'info' => 'Покупка разблокировки невозможна!']));
    }

    if (user()->shilings < $price) {
        exit(json_encode(['status' => '2', 'info' => 'У Вас недостаточно средств!']));
    }

    $shilings = round_shilings(user()->shilings - $price);

    if (
        Integrations::USERS_FILE == $server->type
        || Integrations::AMXBANS_WITH_USERS_FILE == $server->type
        || Integrations::AMXBANS == $server->type
        || Integrations::AMXBANS_WITH_GAMECMS_API == $server->type
    ) {
        $table = 'comms';

        $connection
            ->prepare("UPDATE {$table} SET expired=:expired, modified_by=:modified_by WHERE `bid`=:id LIMIT 1")
            ->execute([':expired' => '-2', ':modified_by' => $_SESSION['id'], ':id' => $id]);
    }

    if (Integrations::SOURCEBANS == $server->type) {
        $table = set_prefix($server->db_prefix, 'comms');

        $connection
            ->prepare("UPDATE {$table} SET RemovedBy=:RemovedBy, RemoveType=:RemoveType, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `bid`=:id LIMIT 1")
            ->execute(
                [
                    ':RemovedBy' => '0',
                    ':RemoveType' => 'U',
                    ':unban_type' => '-2',
                    ':ban_closed' => $_SESSION['id'],
                    ':id' => $id,
                ]
            );
    }

    if (Integrations::IKS == $server->type) {
        $table = set_prefix($server->db_prefix, 'mutes');

        $connection
            ->prepare("UPDATE {$table} SET Unbanned=:Unbanned, `unban_type`=:unban_type, `ban_closed`=:ban_closed WHERE `id`=:id LIMIT 1")
            ->execute(
                [
                    ':Unbanned' => '1',
                    ':unban_type' => '-2',
                    ':ban_closed' => $_SESSION['id'],
                    ':id' => $id,
                ]
            );
    }

    pdo()
        ->prepare('UPDATE users SET shilings=:shilings WHERE id=:id LIMIT 1')
        ->execute([':shilings' => $shilings, ':id' => user()->id]);

    pdo()
        ->prepare('INSERT INTO money__actions (date,shilings,author,type) VALUES (:date, :shilings, :author, :type)')
        ->execute(['date' => date('Y-m-d H:i:s'), 'shilings' => -$price, 'author' => user()->id, 'type' => '9']);

    incNotifications();
    $noty = success_buy_unmute_noty($ban_nick, $ban_steamid, $ban_id);
    send_noty($noty, $_SESSION['id'], 2);

    $noty = success_buy_unmute_noty_for_admin($_SESSION['id'], $_SESSION['login'], $ban_nick, $ban_steamid, $ban_id);
    send_noty($noty, 0, 2);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['get_user_stores'])) {
    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $j = 0;
    $tpl->result['admins'] = '';

    $STH = pdo()->prepare(
        'SELECT admins.id, admins.name, admins.pause, admins.cause, admins.price, admins.link, admins.active, servers.name AS server_name FROM admins
						  LEFT JOIN servers ON servers.id = admins.server
						  WHERE admins.user_id=:user_id ORDER BY admins.server'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':user_id' => $_SESSION['id']]);
    while ($row = $STH->fetch()) {
        ++$j;
        $tpl->load_template('elements/store.tpl');
        $tpl->set('{id}', $row->id);
        $tpl->set('{server}', $row->server_name);
        $tpl->set('{active}', $row->active);
        $tpl->set('{pause}', $row->pause);
        $tpl->set('{cause}', $row->cause);
        $tpl->set('{price}', $row->price);
        $tpl->set('{link}', $row->link);
        $tpl->set('{name}', $row->name);
        $tpl->set('{i}', $j);
        $tpl->compile('stores');
        $tpl->clear();
    }
    if (0 == $j) {
        $tpl->result['stores'] = tableRowError('Привилегий нет');
    }

    $tpl->show($tpl->result['stores']);
    $tpl->global_clear();

    exit;
}
if (isset($_POST['get_stores_info'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit;
    }

    $STH = pdo()->prepare(
        'SELECT admins.*, servers.type AS server_type, servers.binds FROM admins
						  LEFT JOIN servers ON servers.id = admins.server
						  WHERE admins.id=:id'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id]);
    $admin = $STH->fetch();

    if ($admin->user_id != $_SESSION['id']) {
        exit;
    }

    if (empty($admin->pass) and empty($admin->pass_md5)) {
        $admin->pass = '';
    } elseif (empty($admin->pass)) {
        $admin->pass = '';
    }

    if (2 == $admin->active) {
        $class = 'danger';
        $disabled = 'disabled';
    } elseif (0 != $admin->pause) {
        $class = 'warning';
        $disabled = 'disabled';
    } else {
        $class = '';
        $disabled = '';
    }

    $tpl = new Template();
    $tpl->dir = '../templates/'.get_template().'/tpl/';

    $STH = pdo()->query('SELECT return_services FROM config__secondary LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $conf2 = $STH->fetch();

    $i = 0;
    $STH = pdo()->prepare(
        'SELECT admins__services.id, admins__services.rights_und, admins__services.sb_group_und, 
		services.name, admins__services.service, admins__services.bought_date, admins__services.ending_date, 
		services.rights, services.sb_group, services.discount AS service_discount, admins__services.irretrievable, servers.discount 
		FROM admins__services 
		LEFT JOIN services ON admins__services.service = services.id 
		LEFT JOIN servers ON services.server=servers.id 
		WHERE admins__services.admin_id = :admin_id'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':admin_id' => $admin->id]);
    while ($row = $STH->fetch()) {
        $tpl->load_template('elements/store_service.tpl');

        ++$i;
        if (empty($row->service)) {
            $row->name = 'Неизвестно';
        }

        $disp = '';
        if ('0000-00-00 00:00:00' == $row->ending_date) {
            $left = 'Вечность';
            $color = 'success';
            $disp = 'disp-n';
            $row->ending_date = 'Никогда';
        } else {
            $left = strtotime($row->ending_date) - time();
            if ($left > 60 * 60 * 24 * 5) {
                $color = 'success';
            } elseif ($left > 60 * 60 * 24) {
                $color = 'warning';
            } else {
                $color = 'danger';
            }
            $return = floor($left / 3600 / 24) - 1;
            if ($return < 1) {
                $row->irretrievable = 0;
            } else {
                $row->irretrievable = round($return * $row->irretrievable, 2);
            }
            $left = expand_seconds2($left, 2);
            $row->ending_date = date('d.m.Y H:i', strtotime($row->ending_date));
            $row->ending_date = expand_date($row->ending_date, 1);
        }
        if ('0000-00-00 00:00:00' != $row->bought_date) {
            $bought_date_original = $row->bought_date;
            $row->bought_date = expand_date($row->bought_date, 1);
        } else {
            $row->bought_date = 'Неизвестно';
        }
        $services = '';
        if (2 != $admin->active and 'disabled' != $disabled and '' == $disabled and '' == $disp) {
            $STH2 = pdo()->query('SELECT discount FROM config__prices LIMIT 1');
            $STH2->setFetchMode(PDO::FETCH_OBJ);
            $disc = $STH2->fetch();
            $discount = $disc->discount;
            $services .= '<select class="form-control input-sm pd-0" id="extend_time'.$row->id.'">';
            $STH2 = pdo()->query(
                "SELECT 
							    id,
		                        CASE
							        WHEN price_renewal = 0 THEN price
							        ELSE price_renewal
							    END AS price,
							    time,
							    discount 
							FROM 
							    services__tarifs 
							WHERE service = '{$row->service}' 
							ORDER BY price"
            );
            $STH2->setFetchMode(PDO::FETCH_OBJ);
            while ($service = $STH2->fetch()) {
                if (0 == $service->time) {
                    $time = 'Навсегда';
                } else {
                    $time = $service->time.' дня(ей)';
                }

                $proc = calculate_discount(
                    $row->discount,
                    $discount,
                    user()->proc,
                    $row->service_discount,
                    $service->discount
                );
                $price = calculate_price($service->price, $proc);
                if ($price != $service->price) {
                    $services .= '<option value="'.$service->id.'">'.$time.' - '.$price.' '.$messages['RUB'].' (с учетом скидки в '.$proc.'%)</option>';
                } else {
                    $services .= '<option value="'.$service->id.'">'.$time.' - '.$price.' '.$messages['RUB'].'</option>';
                }
            }
            $services .= '</select>';
        }

        if (2 == $conf2->return_services) {
            $row->irretrievable = 0;
        }

        $store_return_time = getConfigAdditional('store_return_time');
        if ($store_return_time) { // в течение какого времени можно сделать возврат
            if ((time() - strtotime($bought_date_original)) > 60 * 60 * $store_return_time) {
                $row->irretrievable = 0;
            }
        }

        $tpl->set('{active}', $admin->active);
        $tpl->set('{pause}', $admin->pause);
        $tpl->set('{disabled}', $disabled);
        $tpl->set('{i}', $i);
        $tpl->set('{name}', $row->name);
        $tpl->set('{id}', $row->id);
        $tpl->set('{id2}', $admin->id);
        $tpl->set('{left}', $left);
        $tpl->set('{disp}', $disp);
        $tpl->set('{color}', $color);
        $tpl->set('{bought_date}', $row->bought_date);
        $tpl->set('{ending_date}', $row->ending_date);
        $tpl->set('{services}', $services);
        $tpl->set('{sum}', $row->irretrievable);
        $tpl->compile('servies');
        $tpl->clear();
    }

    $peg_1 = '2';
    $peg_2 = '2';
    $peg_3 = '2';
    $binds = explode(';', $admin->binds);
    if ($binds[0]) {
        $peg_1 = '1';
    }
    if ($binds[1]) {
        $peg_2 = '1';
    }
    if ($binds[2]) {
        $peg_3 = '1';
    }

    $tpl->load_template('elements/store_info.tpl');
    $tpl->set('{active}', $admin->active);
    $tpl->set('{pause}', $admin->pause);
    $tpl->set('{id}', $admin->id);
    $tpl->set('{price}', $admin->price);
    $tpl->set('{type}', $admin->type);
    $tpl->set('{name}', $admin->name);
    $tpl->set('{pass}', $admin->pass);
    $tpl->set('{class}', $class);
    $tpl->set('{peg_1}', $peg_1);
    $tpl->set('{peg_2}', $peg_2);
    $tpl->set('{peg_3}', $peg_3);
    $tpl->set('{disabled}', $disabled);
    $tpl->set('{services}', $tpl->result['servies'], false);
    $tpl->compile('content');
    $tpl->clear();

    $tpl->show($tpl->result['content']);
    $tpl->global_clear();

    exit;
}
if (isset($_POST['edit_store'])) {
    $id = check($_POST['id'], 'int');
    $type = check($_POST['type'], null);
    $param = check($_POST['param'], null);

    if (empty($id) or empty($type) or empty($param)) {
        exit(json_encode(['status' => '2', 'reply' => 'Заполните все поля!']));
    }

    $STH = pdo()->prepare(
        'SELECT admins.id, admins.active, admins.pause, admins.type, admins.name, admins.pass, admins.pass_md5, servers.type AS server_type, servers.id AS server_id, servers.binds FROM admins 
		LEFT JOIN servers ON servers.id = admins.server
		WHERE admins.id=:id AND admins.user_id=:user_id LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id, ':user_id' => $_SESSION['id']]);
    $admin = $STH->fetch();
    if (empty($admin->id)) {
        exit(json_encode(['status' => '2', 'reply' => 'Ошибка!']));
    }

    if (2 == $admin->active) {
        exit(json_encode(['status' => '2', 'reply' => 'Ваша услуга заблокирована!']));
    }

    if (0 != $admin->pause) {
        exit(json_encode(['status' => '2', 'reply' => 'Услуга приостановлена!']));
    }

    $adminsService = new AdminsService();
    [$isSuccess, $error] = $adminsService->isIntegratorStorageAvailable($admin->server_id);
    if (!$isSuccess) {
        exit(json_encode(['status' => '2', 'reply' => (string) $error]));
    }

    $SIDO = new SteamIDOperations();

    $old_name = null;
    if ('type' == $type) {
        if (0 == configs()->col_type) {
            exit(json_encode(['status' => '2', 'reply' => 'Смена типа привязки запрещена']));
        }

        if ('1' != $param and '2' != $param and '3' != $param) {
            exit(json_encode(['status' => '2', 'reply' => 'Неверно указан тип!']));
        }

        $binds = explode(';', $admin->binds);
        if ((0 == $binds[0] and 1 == $param) || (0 == $binds[1] and 2 == $param) || (0 == $binds[2] and 3 == $param)) {
            exit(json_encode(['status' => '2', 'reply' => 'Данный тип запрещен!']));
        }

        $date = time() - 24 * 60 * 60 * configs()->col_type;
        pdo()->exec(
            "DELETE FROM last_actions WHERE date<'{$date}' and user_id='{$_SESSION['id']}' and action_type = '4' LIMIT 1"
        );

        $STH = pdo()->query("SELECT id,date FROM last_actions WHERE user_id = '{$_SESSION['id']}' and action_type = '4'");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        if (!empty($row->id)) {
            $delta = time() - $row->date;
            if ($delta < (24 * 60 * 60 * configs()->col_type)) {
                exit(
                    json_encode(
                        ['status' => '2', 'reply' => 'Тип привязки разрешено менять раз в '.configs()->col_type.' дн.']
                    )
                );
            }
        }

        if (1 == $param) {
            if (empty($admin->pass) and empty($admin->pass_md5)) {
                exit(json_encode(['status' => '2', 'reply' => 'Сначала укажите пароль!']));
            }

            $STH = pdo()->prepare('UPDATE admins SET type=:type WHERE id=:id LIMIT 1');
            $STH->execute([':type' => 'a', ':id' => $id]);
        }
        if (2 == $param) {
            if (!$admin->name = $SIDO->GetSteamID32($admin->name)) {
                exit(json_encode(['status' => '2', 'reply' => 'Введите корректный STEAM ID!']));
            }

            $STH = pdo()->prepare('UPDATE admins SET type=:type WHERE id=:id LIMIT 1');
            $STH->execute([':type' => 'ce', ':id' => $id]);
        }
        if (3 == $param) {
            if (empty($admin->pass) and empty($admin->pass_md5)) {
                exit(json_encode(['status' => '2', 'reply' => 'Сначала укажите пароль!']));
            }

            if (!$admin->name = $SIDO->GetSteamID32($admin->name)) {
                exit(json_encode(['status' => '2', 'reply' => 'Введите корректный STEAM ID!']));
            }

            $STH = pdo()->prepare('UPDATE admins SET type=:type WHERE id=:id LIMIT 1');
            $STH->execute([':type' => 'ca', ':id' => $id]);

            $STH = pdo()->prepare(
                'INSERT INTO last_actions (user_id,action_type,date) values (:user_id, :action_type, :date)'
            );
            $STH->execute(['user_id' => $_SESSION['id'], 'action_type' => 4, 'date' => time()]);
        }
    }

    if ('name' == $type) {
        if (0 == configs()->col_nick) {
            exit(json_encode(['status' => '2', 'reply' => 'Смена идентификатора запрещена']));
        }
        $date = time() - 24 * 60 * 60 * configs()->col_nick;
        pdo()->exec(
            "DELETE FROM last_actions WHERE date<'{$date}' and user_id='{$_SESSION['id']}' and action_type = '2' LIMIT 1"
        );

        $STH = pdo()->query("SELECT id,date FROM last_actions WHERE user_id = '{$_SESSION['id']}' and action_type = '2'");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        if (!empty($row->id)) {
            $delta = time() - $row->date;
            if ($delta < (24 * 60 * 60 * configs()->col_nick)) {
                exit(
                    json_encode(
                        ['status' => '2', 'reply' => 'Идентификатор разрешено менять раз в '.configs()->col_nick.' дн.']
                    )
                );
            }
        }

        if ('a' == $admin->type) {
            if (mb_strlen($_POST['param'], 'UTF-8') > 32) {
                exit(json_encode(['status' => '2', 'reply' => 'Не более 32 символов!']));
            }
        }
        if ('ce' == $admin->type or 'ca' == $admin->type) {
            if (mb_strlen($param, 'UTF-8') > 32) {
                exit(json_encode(['status' => '2', 'reply' => 'Не более 32 символов!']));
            }
            if (!$param = $SIDO->GetSteamID32($param)) {
                exit(json_encode(['status' => '2', 'reply' => 'Введите корректный STEAM ID!']));
            }
        }

        if (1 == $admin->server_type || 3 == $admin->server_type) {
            if (false !== stristr(htmlspecialchars_decode($param, ENT_QUOTES), '"')) {
                exit(json_encode(['status' => '2', 'reply' => 'Ваш идентификатор содержит запрещенный символ: "']));
            }
            if (false !== stristr(htmlspecialchars_decode($param, ENT_QUOTES), '#')) {
                exit(json_encode(['status' => '2', 'reply' => 'Ваш идентификатор содержит запрещенный символ: #']));
            }
        }

        if (!check_for_bad_nicks($param)) {
            exit(json_encode(['status' => '3', 'data' => 'Использовать данный идентификатор запрещено!']));
        }

        if ('ce' == $admin->type or 'ca' == $admin->type) {
            $STH = pdo()->prepare(
                prepareSearchQuery('SELECT id FROM admins WHERE name LIKE :name AND server=:server LIMIT 1')
            );

            $adminNameForCheck = '%'.strip_data(':'.explode(':', $param)[2]);
        } else {
            $STH = pdo()->prepare('SELECT id FROM admins WHERE name=:name AND server=:server LIMIT 1');

            $adminNameForCheck = $param;
        }

        $STH->setFetchMode(PDO::FETCH_OBJ);
        $STH->execute([':name' => $adminNameForCheck, ':server' => $admin->server_id]);
        $row = $STH->fetch();
        if (isset($row->id)) {
            if ($row->id == $id) {
                exit(json_encode(['status' => '1']));
            }

            exit(json_encode(['status' => '2', 'reply' => 'Идентификатор уже используется другим игроком!']));
        }
        $STH = pdo()->prepare('UPDATE admins SET name=:name WHERE id=:id LIMIT 1');
        $STH->execute([':name' => $param, ':id' => $id]);

        $STH = pdo()->prepare(
            'INSERT INTO last_actions (user_id,action_type,date) VALUES (:user_id, :action_type, :date)'
        );
        $STH->execute(['user_id' => $_SESSION['id'], 'action_type' => 2, 'date' => time()]);

        $old_name = $admin->name;
    }
    if ('pass' == $type) {
        if (0 == configs()->col_pass) {
            exit(json_encode(['status' => '2', 'reply' => 'Смена пароля запрещена']));
        }

        $date = time() - 24 * 60 * 60 * configs()->col_pass;
        pdo()->exec(
            "DELETE FROM last_actions WHERE date<'{$date}' and user_id='{$_SESSION['id']}' and action_type = '1' LIMIT 1"
        );

        $STH = pdo()->query("SELECT id,date FROM last_actions WHERE user_id = '{$_SESSION['id']}' and action_type = '1'");
        $STH->setFetchMode(PDO::FETCH_OBJ);
        $row = $STH->fetch();
        if (!empty($row->id)) {
            $delta = time() - $row->date;
            if ($delta < (24 * 60 * 60 * configs()->col_pass)) {
                exit(
                    json_encode(
                        ['status' => '2', 'reply' => 'Пароль разрешено менять раз в '.configs()->col_pass.' дн.']
                    )
                );
            }
        }

        if (mb_strlen($param, 'UTF-8') > 32) {
            exit(json_encode(['status' => '2', 'reply' => 'Не более 32 символов!']));
        }
        if (1 == $admin->server_type || 3 == $admin->server_type) {
            if (false !== stristr(htmlspecialchars_decode($param, ENT_QUOTES), '"')) {
                exit(json_encode(['status' => '2', 'reply' => 'Ваш пароль содержит запрещенный символ: "']));
            }
            if (false !== stristr(htmlspecialchars_decode($param, ENT_QUOTES), '#')) {
                exit(json_encode(['status' => '2', 'reply' => 'Ваш пароль содержит запрещенный символ: #']));
            }
        }

        $STH = pdo()->prepare('UPDATE admins SET pass=:pass, pass_md5=:pass_md5 WHERE id=:id LIMIT 1');
        $STH->execute([':pass' => $param, ':pass_md5' => md5($param), ':id' => $id]);

        $STH = pdo()->prepare(
            'INSERT INTO last_actions (user_id,action_type,date) VALUES (:user_id, :action_type, :date)'
        );
        $STH->execute(['user_id' => $_SESSION['id'], 'action_type' => 1, 'date' => time()]);
    }

    [$isSuccess, $error] = $adminsService->syncAdminWithIntegratorStorage($id, $old_name);
    if (!$isSuccess) {
        log_error("edit_store: {$error}");

        exit(json_encode(['status' => '2', 'reply' => 'Не удалось экспортировать администратора на игровой сервер']));
    }

    service_log('Пользователь сменил '.$type.' на '.$param, $id, $admin->server_id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['start_store'])) {
    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = pdo()->prepare(
        'SELECT 
					admins.*,
					servers.db_host,
					servers.ip,
					servers.port,
					servers.type AS server_type,
					servers.id AS server_id,
					servers.name AS server_name
				FROM servers 
					LEFT JOIN admins ON admins.server = servers.id 
					WHERE admins.id=:id AND admins.user_id=:user_id 
					LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id, ':user_id' => $_SESSION['id']]);
    $info = $STH->fetch();
    if (empty($info->id)) {
        exit(json_encode(['status' => '2']));
    }

    if (1 == $info->active) {
        exit(json_encode(['status' => '2', 'data' => 'Права уже разблокированы']));
    }

    $STH = pdo()->query("SELECT id,shilings FROM users WHERE id='{$_SESSION['id']}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit(json_encode(['status' => '2']));
    }
    if ($row->shilings < $info->price) {
        $price_delta = round($info->price - $row->shilings, 2);

        exit(
            json_encode(
                [
                    'status' => '2',
                    'data' => 'У Вас недостаточно средств! Пополните баланс на '.$price_delta.$messages['RUB'],
                ]
            )
        );
    }
    $shilings = round_shilings($row->shilings - $info->price);

    $adminsService = new AdminsService();
    [$isSuccess, $error] = $adminsService->isIntegratorStorageAvailable($info->server_id);
    if (!$isSuccess) {
        exit(json_encode(['status' => '2', 'data' => (string) $error]));
    }

    $STH = pdo()->prepare(
        "UPDATE admins SET active=:active,cause=:cause,link=:link,price=:price WHERE id='{$id}' LIMIT 1"
    );
    $STH->execute(['active' => '1', 'cause' => '', 'link' => '', 'price' => 0]);

    $STH = pdo()->prepare('UPDATE users SET shilings=:shilings WHERE id=:id LIMIT 1');
    $STH->execute([':shilings' => $shilings, ':id' => $_SESSION['id']]);

    $STH = pdo()->prepare(
        'INSERT INTO money__actions (date,shilings,author,type) values (:date, :shilings, :author, :type)'
    );
    $STH->execute(
        ['date' => date('Y-m-d H:i:s'), 'shilings' => -$info->price, 'author' => $_SESSION['id'], 'type' => '7']
    );

    [$isSuccess, $error] = $adminsService->syncAdminWithIntegratorStorage($id);
    if (!$isSuccess) {
        log_error("start_store: {$error}");

        exit(json_encode(['status' => '2', 'data' => 'Не удалось экспортировать администратора на игровой сервер']));
    }

    incNotifications();
    $noty = unlock_service_noty($info->name, $info->server_name);
    send_noty($noty, $info->user_id, 2);

    $noty = unlock_service_noty_for_admin(
        $_SESSION['id'],
        $_SESSION['login'],
        clean($info->name, null),
        $info->server_name
    );
    send_noty($noty, 0, 2);

    service_log('Покупка разблокировки прав', $id, $info->server_id);

    exit(json_encode(['status' => '1']));
}
if (isset($_POST['get_return'])) {
    $STH = pdo()->query('SELECT return_services FROM config__secondary LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (2 == $row->return_services) {
        exit(json_encode(['status' => '2']));
    }

    ignore_user_abort(1);
    set_time_limit(getTimeLimit());

    $id = check($_POST['id'], 'int');
    if (empty($id)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = pdo()->prepare(
        'SELECT 
				    services.users_group, 
				    services.id AS service_id, 
				    admins.user_id,
				    admins.active, 
				    admins.pause,
				    admins__services.admin_id, 
				    admins__services.irretrievable, 
				    admins__services.ending_date, 
				    admins__services.bought_date,
				    servers.type AS server_type, 
				    admins.server 
				FROM admins__services 
					LEFT JOIN admins ON admins__services.admin_id = admins.id 
					LEFT JOIN servers ON servers.id = admins.server
					LEFT JOIN services ON services.id = admins__services.service 
					WHERE admins__services.id=:id AND admins.user_id=:user_id LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id, ':user_id' => $_SESSION['id']]);
    $admin = $STH->fetch();
    if (empty($admin->admin_id)) {
        exit(json_encode(['status' => '2']));
    }

    if (2 == $admin->active) {
        exit(json_encode(['status' => '2', 'data' => 'Ваша услуга заблокирована!']));
    }

    if (0 != $admin->pause) {
        exit(json_encode(['status' => '2', 'data' => 'Услуга приостановлена!']));
    }

    if (0 == $admin->irretrievable) {
        exit(json_encode(['status' => '2']));
    }
    $store_return_time = getConfigAdditional('store_return_time');
    if ($store_return_time) {
        if (time() - strtotime($admin->bought_date) > 24 * 60 * 60 * $store_return_time) {
            exit(json_encode(['status' => '2']));
        }
    }

    $adminsService = new AdminsService();
    [$isSuccess, $error] = $adminsService->isIntegratorStorageAvailable($admin->server);
    if (!$isSuccess) {
        exit(json_encode(['status' => '2', 'data' => (string) $error]));
    }

    $left = strtotime($admin->ending_date) - time();
    $return = floor($left / 3600 / 24) - 1;
    if ($return < 1) {
        exit(json_encode(['status' => '2']));
    }
    $admin->irretrievable = round($return * $admin->irretrievable, 2);

    $adminsService->updateAdminGroup($admin->user_id, 0, $id);

    service_log(
        'Пользователь выполнил возврат на сумму: '.$admin->irretrievable.'р',
        $admin->admin_id,
        $admin->server,
        $admin->service_id
    );

    $STH = pdo()->prepare('SELECT id FROM admins__services WHERE admin_id=:id ');
    $STH->execute([':id' => $admin->admin_id]);
    $row = $STH->fetchAll();
    $count = count($row);
    if (1 == $count) {
        [$isSuccess, $error] = $adminsService->dellAdminAndFromSiteAndIntegratorStorage($admin->admin_id);
        if (!$isSuccess) {
            log_error("get_return: {$error}");

            exit(json_encode(['status' => '2']));
        }
        $id = $admin->admin_id;
    } else {
        $STH = pdo()->prepare('DELETE FROM admins__services WHERE id=:id LIMIT 1');
        $STH->execute([':id' => $id]);

        [$isSuccess, $error] = $adminsService->syncAdminWithIntegratorStorage($admin->admin_id);
        if (!$isSuccess) {
            log_error("get_return: {$error}");

            exit(json_encode(['status' => '2', 'data' => 'Не удалось экспортировать администратора на игровой сервер']));
        }

        $id = 0;
    }

    $STH = pdo()->query("SELECT id,shilings FROM users WHERE id='{$_SESSION['id']}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit(json_encode(['status' => '2']));
    }
    $shilings = round_shilings($row->shilings + $admin->irretrievable);

    $STH = pdo()->prepare("UPDATE users SET shilings=:shilings WHERE id='{$_SESSION['id']}' LIMIT 1");
    $STH->execute(['shilings' => $shilings]);

    $STH = pdo()->prepare(
        'INSERT INTO money__actions (date,shilings,author,type) VALUES (:date, :shilings, :author, :type)'
    );
    $STH->execute(
        [
            'date' => date('Y-m-d H:i:s'),
            'shilings' => $admin->irretrievable,
            'author' => $_SESSION['id'],
            'type' => '10',
        ]
    );

    exit(json_encode(['status' => '1', 'id' => $id, 'shilings' => $shilings]));
}
if (isset($_POST['buy_extend'])) {
    ignore_user_abort(1);
    set_time_limit(getTimeLimit());

    $id = check($_POST['id'], 'int');
    $time = check($_POST['time'], null);

    if (empty($id) or empty($time)) {
        exit(json_encode(['status' => '2']));
    }

    $STH = pdo()->prepare(
        'SELECT 
				    services.name AS service_name, 
    				services.id AS service_id, 
				    admins__services.service, 
				    admins__services.ending_date, 
				    admins.id, 
				    admins.active, 
				    admins.pause, 
				    admins.name, 
				    admins__services.irretrievable, 
				    admins.user_id, 
				    servers.type AS server_type, 
				    servers.id AS server_id, 
				    servers.name AS server_name, 
				    servers.address AS server_address, 
				    servers.discount, 
				    services.discount AS service_discount 
				FROM admins__services 
					LEFT JOIN admins ON admins__services.admin_id = admins.id 
					LEFT JOIN servers ON admins.server = servers.id
					LEFT JOIN services ON services.id = admins__services.service
					WHERE admins__services.id=:id AND admins.user_id=:user_id LIMIT 1'
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $STH->execute([':id' => $id, ':user_id' => $_SESSION['id']]);
    $admin = $STH->fetch();
    if (empty($admin->id)) {
        exit(json_encode(['status' => '2']));
    }

    if (2 == $admin->active) {
        exit(json_encode(['status' => '2', 'data' => 'Ваша услуга заблокирована!']));
    }

    if (0 != $admin->pause) {
        exit(json_encode(['status' => '2', 'data' => 'Услуга приостановлена!']));
    }

    $adminsService = new AdminsService();
    [$isSuccess, $error] = $adminsService->isIntegratorStorageAvailable($admin->server_id);
    if (!$isSuccess) {
        exit(json_encode(['status' => '2', 'data' => (string) $error]));
    }

    $STH = pdo()->query(
        "SELECT 
					    id,
					    time,
					    CASE
							WHEN price_renewal = 0 THEN price
							ELSE price_renewal
						END AS price,
					    discount 
					FROM 
					    services__tarifs 
					WHERE id='{$time}' and service='{$admin->service}'"
    );
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $tarif = $STH->fetch();
    if (empty($tarif->id)) {
        exit(json_encode(['status' => '2']));
    }
    $STH = pdo()->query('SELECT discount FROM config__prices LIMIT 1');
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $disc = $STH->fetch();

    $proc = calculate_discount(
        $admin->discount,
        $disc->discount,
        user()->proc,
        $admin->service_discount,
        $tarif->discount
    );
    $tarif->price = calculate_price($tarif->price, $proc);

    $STH = pdo()->query("SELECT id,shilings FROM users WHERE id='{$_SESSION['id']}' LIMIT 1");
    $STH->setFetchMode(PDO::FETCH_OBJ);
    $row = $STH->fetch();
    if (empty($row->id)) {
        exit(json_encode(['status' => '2']));
    }

    if ($row->shilings < $tarif->price) {
        $price_delta = round($tarif->price - $row->shilings, 2);

        exit(
            json_encode(
                [
                    'status' => '2',
                    'data' => 'У Вас недостаточно средств! Пополните баланс на '.$price_delta.$messages['RUB'],
                ]
            )
        );
    }
    $shilings = round_shilings($row->shilings - $tarif->price);

    if (0 == $tarif->time) {
        $date = '0000-00-00 00:00:00';
        $irretrievable = 0;
    } else {
        $date = strtotime($admin->ending_date) + $tarif->time * 24 * 3600;
        $date = date('Y-m-d H:i:s', $date);

        $old_left = floor((strtotime($admin->ending_date) - time()) / 3600 / 24);
        $old_full_price = $old_left * $admin->irretrievable;
        $irretrievable = calculate_return($tarif->price + $old_full_price, $tarif->time + $old_left);
    }

    if (isset($one_day_extension)) {
        if (strtotime($admin->ending_date) - time() > 24 * 60 * 60 * $one_day_extension) {
            exit(
                json_encode(
                    ['status' => '2', 'data' => 'Услугу можно продлить за '.$one_day_extension.' день до ее окончания.']
                )
            );
        }
    }

    $STH = pdo()->prepare(
        'UPDATE admins__services SET ending_date=:ending_date, service_time=:service_time, irretrievable=:irretrievable WHERE id=:id LIMIT 1'
    );
    $STH->execute(
        [':ending_date' => $date, ':service_time' => $time, ':irretrievable' => $irretrievable, ':id' => $id]
    );

    [$isSuccess, $error] = $adminsService->syncAdminWithIntegratorStorage($admin->id);
    if (!$isSuccess) {
        log_error("buy_extend: {$error}");

        exit(json_encode(['status' => '2', 'data' => 'Не удалось экспортировать администратора на игровой сервер']));
    }

    incNotifications();
    $noty = buy_extend_noty($admin->name, $admin->service_name, $admin->server_name, $date);
    send_noty($noty['message'], $_SESSION['id'], $noty['type']);

    $noty = success_buy_extend_noty_for_admin(
        $_SESSION['id'],
        $_SESSION['login'],
        $tarif->time,
        $date,
        $admin->server_name,
        $admin->server_address,
        $admin->service_name
    );
    send_noty($noty, 0, 2);

    $STH = pdo()->prepare("UPDATE users SET shilings=:shilings WHERE id='{$_SESSION['id']}' LIMIT 1");
    $STH->execute(['shilings' => $shilings]);

    $STH = pdo()->prepare(
        'INSERT INTO money__actions (date,shilings,author,type) values (:date, :shilings, :author, :type)'
    );
    $STH->execute(
        ['date' => date('Y-m-d H:i:s'), 'shilings' => -$tarif->price, 'author' => $_SESSION['id'], 'type' => '6']
    );

    service_log('Пользователь продлил права до: '.$date, $admin->id, $admin->server_id, $admin->service_id);

    exit(json_encode(['status' => '1', 'shilings' => $shilings]));
}
