<?php

use GameCMS\Services\SteamApi\Authorization as SteamAuthorization;
use GameCMS\Services\SteamApi\Users as SteamApiUsers;
use GameCMS\Services\VkApi\Authorization as VkAuthorization;
use GameCMS\Services\VkApi\Users as VkApiUsers;

include_once __DIR__.'/../inc/start.php';

global $conf, $pdo, $full_site_host, $SC, $users_groups, $messages, $protocol, $host, $token;

$AA = new AuthApi();
$auth_api = $AA->auth_api_info();

if (isset($_POST['get_vk_auth_link'])) {
    $url = '#';

    if ($auth_api->vk_api == 1) {
        $vkAuthorization = new VkAuthorization($auth_api->vk_id, configs()->vk_api_version, getVkApiTimeout());

        $pages_urls = $AA->redirectPage();

        $url = $vkAuthorization->getAuthorizationUrl(
            $full_site_host.$pages_urls['main'],
            'login'
        );
    }

    exit(json_encode(['url' => $url]));
}
if (isset($_POST['attach_user_vk']) && is_auth()) {
    $url = '#';

    if ($auth_api->vk_api == 1) {
        $AA->setAttachCache();

        $vkAuthorization = new VkAuthorization($auth_api->vk_id, configs()->vk_api_version, getVkApiTimeout());

        $pages_urls = $AA->redirectPage();

        $url = $vkAuthorization->getAuthorizationUrl(
            $full_site_host.$pages_urls['settings'],
            md5($SC->set_token())
        );
    }

    exit(json_encode(['url' => $url]));
}
if (isset($_POST['get_steam_auth_link'])) {
    $url = '#';

    if ($auth_api->steam_api == 1) {
        $pages_urls = $AA->redirectPage();

        $steamAuthorization = new SteamAuthorization(
            $full_site_host,
            $auth_api->steam_key,
            getSteamApiTimeout()
        );

        [$url, $error] = $steamAuthorization->getAuthorizationUrl(
            $full_site_host.$pages_urls['main'].'?steam_auth=1',
            'login'
        );
        if ($error) {
            $url = '#';
            log_error('steam-auth-link:'.$error);
        }
    }

    exit(json_encode(['url' => $url]));
}
if (isset($_POST['attach_user_steam']) && is_auth()) {
    $url = '#';

    if ($auth_api->steam_api == 1) {
        $AA->setAttachCache();

        $steamAuthorization = new SteamAuthorization(
            $full_site_host,
            $auth_api->steam_key,
            getSteamApiTimeout()
        );

        $pages_urls = $AA->redirectPage();

        [$url, $error] = $steamAuthorization->getAuthorizationUrl(
            $full_site_host.$pages_urls['settings'].'?steam_attach=1',
            md5($SC->set_token())
        );
        if ($error) {
            $url = '#';
            log_error('steam-attach-link:'.$error);
        }
    }

    exit(json_encode(['url' => $url]));
}
if (isset($_POST['get_fb_auth_link'])) {
    $url = '#';

    if ($auth_api->fb_api == 1) {
        $pages_urls = $AA->redirectPage();

        $params = [
            'client_id' => $auth_api->fb_id,
            'redirect_uri' => $full_site_host.$pages_urls['main'].'?fb_auth=1',
            'response_type' => 'code',
        ];

        $url = str_replace(
            '&amp;',
            '&',
            'https://www.facebook.com/dialog/oauth?'.urldecode(http_build_query($params))
        );
    }

    exit(json_encode(['url' => $url]));
}
if (isset($_POST['attach_user_fb']) && is_auth()) {
    $url = '#';

    if ($auth_api->fb_api == 1) {
        $pages_urls = $AA->redirectPage();
        $AA->setAttachCache();

        $params = [
            'client_id' => $auth_api->fb_id,
            'redirect_uri' => $full_site_host.$pages_urls['settings'].'?fb_attach=1&state='.md5($SC->set_token()),
            'response_type' => 'code',
        ];

        $url = str_replace(
            '&amp;',
            '&',
            'https://www.facebook.com/dialog/oauth?'.urldecode(http_build_query($params))
        );
    }

    exit(json_encode(['url' => $url]));
}
if (isset($_POST['reg_by_api'])) {
    $email = check($_POST['email']);
    $type = check($_POST['type']);
    if (empty($email)) {
        exit(json_encode(['data' => '<p class="text-danger">Введите e-mail!</p>']));
    }

    $U = new Users();

    if (!$U->check_email($email)) {
        exit(json_encode(['data' => '<p class="text-danger">Неверно введен е-mail!</p>']));
    }
    if (!$U->check_email_busyness($email)) {
        exit(json_encode(['data' => '<p class="text-danger">Введенный Вами E-mail уже зарегистрирован!</p>']));
    }

    $pages_urls = $AA->redirectPage();

    if ($type == 'vk') {
        if ($auth_api->vk_api == 1) {
            $vkAuthorization = new VkAuthorization($auth_api->vk_id, configs()->vk_api_version, getVkApiTimeout());

            $pages_urls = $AA->redirectPage();

            $url = $vkAuthorization->getAuthorizationUrl(
                $full_site_host.$pages_urls['main'],
                $email
            );

            exit(
                json_encode(
                    [
                        'data' => '<script>$("#api_reg_btn").fadeOut(0); document.location.href = "'.$url
                            .'";</script><p class="text-success">Если Вас не перенаправило на сайт Вконтакте автоматически, то нажмите на ссылку: <a href="'
                            .$url.'">перейти</a></p>',
                    ]
                )
            );
        }

        exit(json_encode(['data' => '<p class="text-danger">Регистрация через Вконтакте недоступна!</p>']));
    }
    if ($type == 'steam') {
        if ($auth_api->steam_api == 1) {
            $steamAuthorization = new SteamAuthorization(
                $full_site_host,
                $auth_api->steam_key,
                getSteamApiTimeout()
            );

            $pages_urls = $AA->redirectPage();

            [$url, $error] = $steamAuthorization->getAuthorizationUrl(
                $full_site_host.$pages_urls['main'].'?steam_reg=1',
                $email
            );
            if ($error) {
                log_error('steam-auth-link:'.$error);

                exit(json_encode(['data' => '<p class="text-danger">Ошибка</p>']));
            }

            exit(
                json_encode(
                    ['data' => '<script>$("#api_reg_btn").fadeOut(0); document.location.href = "'.$url.'";</script><p class="text-success">Если Вас не перенаправило на сайт Steam автоматически, то нажмите на ссылку: <a href="'.$url.'">перейти</a></p>']
                )
            );
        }

        exit(json_encode(['data' => '<p class="text-danger">Регистрация через Steam недоступна!</p>']));
    }
    if ($type == 'fb') {
        if ($auth_api->fb_api == 1) {
            $params = [
                'client_id' => $auth_api->fb_id,
                'redirect_uri' => $full_site_host.$pages_urls['main'].'?fb_reg=1',
                'response_type' => 'code',
                'state' => $email,
            ];
            $url = 'https://www.facebook.com/dialog/oauth?'.urldecode(http_build_query($params));
            $url = str_replace('&amp;', '&', $url);

            exit(
                json_encode(
                    [
                        'data' => '<script>$("#api_reg_btn").fadeOut(0); document.location.href = "'.$url
                            .'";</script><p class="text-success">Если Вас не перенаправило на сайт Facebook автоматически, то нажмите на ссылку: <a href="'
                            .$url.'">перейти</a></p>',
                    ]
                )
            );
        }

        exit(json_encode(['data' => '<p class="text-danger">Регистрация через Facebook недоступна!</p>']));
    }

    exit(json_encode(['data' => '<p class="text-danger">Ошибка</p>']));
}
if (isset($_POST['get_vk_profile_info'])) {
    $ids = explode(',', check($_POST['ids']));
    foreach ($ids as $key => $id) {
        $ids[$key] = check($id, 'int');
    }

    if (empty($ids) || count($ids) === 0 || $auth_api->vk_api == 2) {
        exit(json_encode([]));
    }

    $vkUsersService = new VkApiUsers($auth_api->vk_service_key, configs()->vk_api_version, getVkApiTimeout());
    [$users, $error] = $vkUsersService->getInfo($ids);
    if ($error) {
        exit(json_encode([]));
    }

    if (!$users || !$users[0]) {
        exit(json_encode([]));
    }

    $items = [];
    foreach ($users as $user) {
        $items[$user->user_id] = [
            'avatar' => $user->photo,
            'first_name' => clean($user->first_name),
            'last_name' => clean($user->last_name),
        ];
    }

    exit(json_encode($items));
}
if (isset($_POST['get_user_steam_info'])) {
    $steamId = check($_POST['steam_api']);

    $defaultResponse = ['avatar' => '../files/avatars/no_avatar.jpg', 'login' => 'Неизвестно'];

    if (empty($steamId) || $auth_api->steam_api == 2) {
        exit(json_encode($defaultResponse));
    }

    $steamUsersService = new SteamApiUsers($auth_api->steam_key, getSteamApiTimeout());
    [$users, $error] = $steamUsersService->getInfo([$steamId]);
    if ($error) {
        exit(json_encode($defaultResponse));
    }

    if (!$users || !$users[0]) {
        exit(json_encode($defaultResponse));
    }

    exit(json_encode(['avatar' => clean($users[0]->avatar), 'login' => clean($users[0]->login)]));
}
if (isset($_POST['get_fb_profile_info'])) {
    $fb_api = check($_POST['fb_api']);

    if (empty($fb_api) || $auth_api->fb_api == 2) {
        exit(json_encode(['login' => 'none']));
    }

    $content = file_get_contents_curl(
        'https://graph.facebook.com/'.$fb_api.'?fields=id,name&access_token='.$auth_api->fb_id.'|'.$auth_api->fb_key
    );

    $content = json_decode($content, true);

    if (empty($content['name'])) {
        exit(json_encode(['login' => 'none']));
    }

    exit(json_encode(['login' => clean($content['name'])]));
}
