<?php

namespace GameCMS\Common;

class Error
{
    private string $message;
    private ?string $slug;

    public function __construct(string $message, ?string $slug = null)
    {
        $this->message = $message;
        $this->slug = $slug;

        return $this;
    }

    public function __toString()
    {
        return $this->message;
    }

    public function is(string $slug): bool
    {
        return !empty($this->slug) && $this->slug === $slug;
    }
}
