<?php

namespace GameCMS\Repositories;

use GameCMS\Models\Admin;

class AdminRepository
{
    public static function getById(int $adminId): ?Admin
    {
        $STH = pdo()->prepare(
            'SELECT 
						admins.*, 
					    users.email, 
					    users.nick 
					FROM 
						admins 
					LEFT JOIN users ON admins.user_id = users.id 
					WHERE admins.id=:id 
					LIMIT 1'
        );
        $STH->execute([':id' => $adminId]);

        return $STH->fetchObject(Admin::class);
    }

    /**
     * @return Admin[]
     */
    public static function getActiveByServerId(int $serverId): array
    {
        $STH = pdo()->prepare(
            'SELECT 
						admins.*,
						users.email, 
					    users.nick 
					FROM 
						servers 
					LEFT JOIN admins ON admins.server = servers.id
					LEFT JOIN users ON admins.user_id = users.id 
					WHERE servers.id=:server_id 
					  AND admins.active = 1 
					  AND admins.pause = 0'
        );
        $STH->execute([':server_id' => $serverId]);

        return $STH->fetchAll(\PDO::FETCH_CLASS, Admin::class);
    }

    public static function removeById(int $adminId)
    {
        pdo()
            ->prepare('DELETE FROM admins WHERE id=:id')
            ->execute([':id' => $adminId]);
        pdo()
            ->prepare('DELETE FROM admins__services WHERE admin_id=:admin_id')
            ->execute([':admin_id' => $adminId]);
    }

    public static function removeByServerId(int $serverId)
    {
        $STH = pdo()->prepare('SELECT id FROM admins WHERE server=:id');
        $STH->execute([':id' => $serverId]);
        while ($row = $STH->fetchObject()) {
            pdo()
                ->prepare('DELETE FROM admins__services WHERE admin_id=:id')
                ->execute([':id' => $row->id]);
        }

        pdo()
            ->prepare('DELETE FROM admins WHERE server=:id')
            ->execute([':id' => $serverId]);
    }
}
