<?php

namespace GameCMS\Services\HeadApi;

use GameCMS\Clients\Curl;
use GameCMS\Common\Error;

class Client
{
    public const URL = 'https://gamecms.ru/';
    public const HEADER = 'x-gamecms-client-request';

    /**
     * @return array{?Curl, ?Error}
     */
    public static function get(int $timeout = 1): array
    {
        try {
            $curl = new Curl();
            $curl->setUrl(self::URL);
            $curl->setTimeout($timeout);
            $curl->setHeader(self::HEADER, '1');
        } catch (\Exception $exception) {
            return [null, error($exception->getMessage())];
        }

        return [$curl, null];
    }
}
