<?php

namespace GameCMS\Services;

use GameCMS\Statistics\ArmyRanksUltimateIntegration;
use GameCMS\Statistics\BlankIntegration;
use GameCMS\Statistics\CMSStatsMysqlIntegration;
use GameCMS\Statistics\CsStatsMysqlIntegration;
use GameCMS\Statistics\CsStatsxSqlIntegration;
use GameCMS\Statistics\HlStatsxCeIntegration;
use GameCMS\Statistics\Integrations;
use GameCMS\Statistics\LevelsRanksIntegration;
use GameCMS\Statistics\RankMeIntegration;
use GameCMS\Statistics\StatisticIntegration;

class StatisticsService
{
    public function getIntegrator(int $integration): ?StatisticIntegration
    {
        switch ($integration) {
            case Integrations::CSSTATS_MYSQL:
                return new CsStatsMysqlIntegration();

            case Integrations::ARMY_RANKS_ULTIMATE:
                return new ArmyRanksUltimateIntegration();

            case Integrations::CSSTATSX_SQL:
                return new CsStatsxSqlIntegration();

            case Integrations::HLSTATSX_CE:
                return new HlStatsxCeIntegration();

            case Integrations::RANKME:
                return new RankMeIntegration();

            case Integrations::LEVELS_RANKS:
                return new LevelsRanksIntegration();

            case Integrations::CMSSTATS_MYSQL:
                return new CMSStatsMysqlIntegration();

            case Integrations::BLANK:
            default:
                return new BlankIntegration();
        }
    }

    public function isValidStatisticsIntegrationType(int $type): bool
    {
        return in_array($type, [
            Integrations::BLANK,
            Integrations::CSSTATS_MYSQL,
            Integrations::ARMY_RANKS_ULTIMATE,
            Integrations::CSSTATSX_SQL,
            Integrations::HLSTATSX_CE,
            Integrations::RANKME,
            Integrations::LEVELS_RANKS,
            Integrations::CMSSTATS_MYSQL,
        ]);
    }
}
