<?php

namespace GameCMS\Services\VkApi;

use GameCMS\Common\Error;
use GameCMS\Services\VkApi\DTO\UsersGetInfoDTO;
use VK\Client\Enums\VKLanguage;
use VK\Client\VKApiClient;

class Users
{
    private VKApiClient $client;
    private string $secret;

    public function __construct(
        string $secret,
        string $apiVersion,
        int $timeout = 10
    ) {
        $this->client = new VKApiClient($apiVersion, VKLanguage::RUSSIAN);
        $this->secret = $secret;
    }

    /**
     * @return array{?UsersGetInfoDTO[], ?Error}
     */
    public function getInfo(array $vkIds): array
    {
        try {
            $usersGetResponse = $this->client->users()->get($this->secret, [
                'user_ids' => $vkIds,
                'fields' => 'id,first_name,last_name,photo_max,has_photo,bdate',
            ]);
        } catch (\Exception $e) {
            return [null, error($e->getMessage())];
        }

        $items = [];
        foreach ($usersGetResponse as $user) {
            $item = new UsersGetInfoDTO();
            $item->user_id = $user['id'];
            $item->birth_day = $user['bdate'] ?? null;
            $item->first_name = $user['first_name'];
            $item->last_name = $user['last_name'];
            $item->photo = $user['photo_max'];
            $item->has_photo = (bool) $user['has_photo'];

            $items[] = $item;
        }

        return [$items, null];
    }
}
