<?php
global $PI;

if(!is_auth()){
	show_error_page('not_auth');
}

if(!is_worthy("j")) {
	show_error_page('not_allowed');
}

$serverId = getPageParam('server');

$adminsService = new GameCMS\Services\AdminsService();

if($serverId) {
	$server = \GameCMS\Repositories\ServerRepository::getById($serverId);
	if(empty($server)) {
		show_error_page('servers_not_configured');
	}

	$integrator = $adminsService->getIntegrator($server->type);
	if($integrator->isBlank()) {
		show_error_page('servers_not_configured');
	}
} else {
	$servers = \GameCMS\Repositories\ServerRepository::getAll();
	foreach($servers as $serverItem) {
		$integrator = $adminsService->getIntegrator($serverItem->type);
		if(!$integrator->isBlank() && is_worthy_specifically("j", $serverItem->id)) {
			$server = $serverItem;
			break;
		}
	}
}

if(empty($server)) {
	show_error_page('not_allowed');
}

$binds = [0, 0, 0];
if(isset($server->id)) {
	$binds = explode(';', $server->binds);
}

tpl()->load_template('elements/title.tpl');
tpl()->set("{title}", page()->title);
tpl()->set("{name}", configs()->name);
tpl()->compile( 'title' );
tpl()->clear();

tpl()->load_template('head.tpl');
tpl()->set("{title}", tpl()->result['title'], false);
tpl()->set("{site_name}", configs()->name);
tpl()->set("{image}", page()->image);
tpl()->set("{robots}", page()->robots);
tpl()->set("{type}", page()->kind);
tpl()->set("{description}", page()->description);
tpl()->set("{keywords}", page()->keywords);
tpl()->set("{url}", page()->full_url);
tpl()->set("{other}", getLibAssets('timepicker'));
tpl()->set("{token}", token());
tpl()->set("{cache}", configs()->cache);
tpl()->set("{template}", get_template());
tpl()->compile( 'content' );
tpl()->clear();

$menu = tpl()->get_menu();

$nav = [
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('admins', 0, 0),
	$PI->to_nav('edit_admins', 1, 0)
];
$nav = tpl()->get_nav($nav, 'elements/nav_li.tpl');

include_once __DIR__ . '/../../inc/authorized.php';


tpl()->result['options'] = '';

foreach(GameCMS\Repositories\ServerRepository::getAll() as $serverItem) {
	if(!$adminsService->getIntegrator($serverItem->type)->isBlank()) {
		if(is_worthy_specifically("j", $serverItem->id)) {
			tpl()->compileOption(
				$serverItem->name,
				$serverItem->id . '" title="' . $serverItem->type,
				$serverItem->id == $server->id,
				'server'
			);
		}
	}
}

tpl()->load_template('home/edit_admins.tpl');
tpl()->set("{template}", get_template());
tpl()->set("{servers}", tpl()->result['options'], false);
tpl()->set("{server}", $server->id);
tpl()->set("{server_type}", $server->type);
tpl()->compile( 'content' );
tpl()->clear();