<?php

global $tpl, $messages, $PI;

if(page()->privacy == 1 && !is_auth()) {
	show_error_page('not_auth');
}

$serverId = getPageParam('server');
$number   = getPageParam('page');
$limit    = getLimit('bans_lim');
$start    = getPageStartPosition($number, $limit);

$count           = 0;
$count_active    = 0;
$count_permanent = 0;
$count_temporal  = 0;

$bansService = new GameCMS\Services\BansService();

if($serverId) {
	$server = \GameCMS\Repositories\ServerRepository::getById($serverId);
	if(empty($server)) {
		show_error_page('servers_not_configured');
	}

	$integrator = $bansService->getIntegrator($server->type);
	if($integrator->isBlank()) {
		show_error_page('servers_not_configured');
	}
} else {
	$servers = \GameCMS\Repositories\ServerRepository::getAll();
	foreach($servers as $serverItem) {
		$integrator = $bansService->getIntegrator($serverItem->type);
		if(!$integrator->isBlank()) {
			$server = $serverItem;
			break;
		}
	}
}

if(empty($server)) {
	show_error_page('servers_not_configured');
}

$page_name = "../banlist?server={$server->id}&";

[$connection, $error] = $integrator->getStorageConnection($server);
if($error) {
	$error = $messages['errorConnectingToDatabase'];
} else {
	$now = time();

	if(
		$server->type == \GameCMS\Integrations\Integrations::AMXBANS
		|| $server->type == \GameCMS\Integrations\Integrations::AMXBANS_WITH_USERS_FILE
		|| $server->type == \GameCMS\Integrations\Integrations::AMXBANS_WITH_GAMECMS_API
	) {
		$address = $server->ip . ':' . $server->port;

		$table           = set_prefix($server->db_prefix, 'bans');
		$count           = get_rows_count($connection, $table, "server_ip = '$address'");
		$count_active    = get_rows_count(
			$connection,
			$table,
			"(unban_type IS NULL AND expired = 0 AND (((ban_created + ban_length*60) > '$now' AND ban_length != 0)) OR ban_length = 0) AND server_ip = '$address'"
		);
		$count_permanent = get_rows_count($connection, $table, "ban_length = 0 AND server_ip = '$address'");
		$count_temporal  = get_rows_count($connection, $table, "ban_length != 0 AND server_ip = '$address'");
	}
	if($server->type == \GameCMS\Integrations\Integrations::SOURCEBANS) {
		$table = set_prefix($server->db_prefix, 'servers');
		$STH   = $connection->query(
			"SELECT sid FROM $table WHERE ip='{$server->ip}' and port='{$server->port}' LIMIT 1"
		);
		$STH->setFetchMode(PDO::FETCH_OBJ);
		$row = $STH->fetch();
		$sid = $row->sid;

		$table           = set_prefix($server->db_prefix, 'bans');
		$count           = get_rows_count($connection, $table, "sid = '$sid' OR sid = 0");
		$count_active    = get_rows_count(
			$connection,
			$table,
			"unban_type IS NULL AND RemoveType IS NULL AND ((created + length > '$now' AND length != 0) OR length = 0) AND (sid = '$sid' OR sid = 0)"
		);
		$count_permanent = get_rows_count($connection, $table, "length = '0' AND (sid = '$sid' OR sid = 0)");
		$count_temporal  = get_rows_count($connection, $table, "length != '0' AND (sid = '$sid' OR sid = 0)");
	}
	if($server->type == \GameCMS\Integrations\Integrations::IKS) {
		$table           = set_prefix($server->db_prefix, 'bans');
		$count           = get_rows_count(
			$connection,
			$table,
			"server_id = {$server->integration_server_id} OR server_id = 0"
		);
		$count_active    = get_rows_count(
			$connection,
			$table,
			"Unbanned = 0 AND (end > {$now} OR end = 0) AND (server_id = {$server->integration_server_id} OR server_id = 0)"
		);
		$count_permanent = get_rows_count(
			$connection,
			$table,
			"time = 0 AND (server_id = {$server->integration_server_id} OR server_id = 0)"
		);
		$count_temporal  = get_rows_count(
			$connection,
			$table,
			"time != 0 AND (server_id = {$server->integration_server_id} OR server_id = 0)"
		);
	}
}

resetIfPaginationIncorrect($number, $limit, $count, '../banlist');

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", page()->title);
$tpl->set("{name}", configs()->name);
$tpl->compile('title');
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title'], false);
$tpl->set("{site_name}", configs()->name);
$tpl->set("{image}", page()->image);
$tpl->set("{robots}", page()->robots);
$tpl->set("{type}", page()->kind);
$tpl->set("{description}", page()->description);
$tpl->set("{keywords}", page()->keywords);
$tpl->set("{url}", page()->full_url);
$tpl->set("{other}", getLibAssets('timepicker'));
$tpl->set("{token}", token());
$tpl->set("{cache}", configs()->cache);
$tpl->set("{template}", get_template());
$tpl->compile('content');
$tpl->clear();

$menu = $tpl->get_menu();
$nav  = [
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('banlist', 1, 0)
];
$nav  = $tpl->get_nav($nav, 'elements/nav_li.tpl');

if(is_auth()) {
	include_once __DIR__ . '/../../inc/authorized.php';
} else {
	include_once __DIR__ . '/../../inc/not_authorized.php';
}

$tpl->result['categories'] = '';

foreach(GameCMS\Repositories\ServerRepository::getAll() as $serverItem) {
	if(!$bansService->getIntegrator($serverItem->type)->isBlank()) {
		tpl()->compileCategory(
			$serverItem->name,
			'../banlist?server=' . $serverItem->id,
			$serverItem->id == $server->id,
			'banlist'
		);
	}
}

$tpl->load_template('/home/banlist.tpl');
$tpl->set("{template}", get_template());
$tpl->set("{start}", $start);
$tpl->set("{limit}", $limit);
$tpl->set("{server}", $server->id);
$tpl->set("{error}", $error ?? "");
$tpl->set("{servers}", $tpl->result['categories'], false);
$tpl->set("{count}", $count);
$tpl->set("{count_active}", $count_active);
$tpl->set("{count_permanent}", $count_permanent);
$tpl->set("{count_temporal}", $count_temporal);
$tpl->set("{pagination}", $tpl->paginator($number, $count, $limit, $page_name));
$tpl->compile('content');
$tpl->clear();