<?php

global $tpl;
global $messages;
global $PI;

if(page()->privacy == 1 && !is_auth()) {
	show_error_page('not_auth');
}

$serverId = getPageParam('server');
$number   = getPageParam('page');
$limit    = getLimit('muts_lim');
$start    = getPageStartPosition($number, $limit);

$count           = 0;
$count_active    = 0;
$count_permanent = 0;
$count_temporal  = 0;

$mutesService = new GameCMS\Services\MutesService();

if($serverId) {
	$server = \GameCMS\Repositories\ServerRepository::getById($serverId);
	if(empty($server)) {
		show_error_page('servers_not_configured');
	}

	$integrator = $mutesService->getIntegrator($server->type);
	if($integrator->isBlank()) {
		show_error_page('servers_not_configured');
	}
} else {
	$servers = \GameCMS\Repositories\ServerRepository::getAll();
	foreach($servers as $serverItem) {
		$integrator = $mutesService->getIntegrator($serverItem->type);
		if(!$integrator->isBlank()) {
			$server = $serverItem;
			break;
		}
	}
}

if(empty($server)) {
	show_error_page('servers_not_configured');
}

$page_name = "../muts?server={$server->id}&";

[$connection, $error] = $integrator->getStorageConnection($server);
if($error) {
	$error = $messages['errorConnectingToDatabase'];
} else {
	$now = time();

	if(
		$server->type == \GameCMS\Integrations\Integrations::USERS_FILE
		|| $server->type == \GameCMS\Integrations\Integrations::AMXBANS
		|| $server->type == \GameCMS\Integrations\Integrations::AMXBANS_WITH_USERS_FILE
		|| $server->type == \GameCMS\Integrations\Integrations::AMXBANS_WITH_GAMECMS_API
	) {
		$serverId = $server->id;

		$table = 'comms';

		if(check_table($table, $connection)) {
			$count           = get_rows_count($connection, $table, "server_id = '$serverId'");
			$count_active    = get_rows_count(
				$connection,
				$table,
				"((expired != '-1' AND expired != '-2' AND (created+length*60 > '$now' AND length!='0')) OR (expired != '-1' AND expired != '-2' AND length='0')) AND server_id = '$serverId'"
			);
			$count_permanent = get_rows_count($connection, $table, "length = '0' AND server_id = '$serverId'");
			$count_temporal  = get_rows_count($connection, $table, "length != '0' AND server_id = '$serverId'");
		} else {
			$error = $messages['Not_found_tables'];
		}
	}

	if($server->type == \GameCMS\Integrations\Integrations::SOURCEBANS) {
		$table = set_prefix($server->db_prefix, 'servers');
		$STH   = $connection->query(
			"SELECT sid FROM $table WHERE ip='{$server->ip}' and port='{$server->port}' LIMIT 1"
		);
		$STH->setFetchMode(PDO::FETCH_OBJ);
		$row = $STH->fetch();
		$sid = $row->sid;

		$table = set_prefix($server->db_prefix, 'comms');
		if(check_table($table, $connection)) {
			$count           = get_rows_count($connection, $table, "sid = '$sid' || sid = 0");
			$count_active    = get_rows_count(
				$connection,
				$table,
				"((RemoveType is NULL AND (created+length > '$now' AND length!='0')) OR (RemoveType is NULL AND length='0')) AND (sid = '$sid' || sid = 0)"
			);
			$count_permanent = get_rows_count($connection, $table, "length = '0' AND (sid = '$sid' || sid = 0)");
			$count_temporal  = get_rows_count($connection, $table, "length != '0' AND (sid = '$sid' || sid = 0)");
		} else {
			$error = $messages['Not_found_tables'];
		}
	}

	if($server->type == \GameCMS\Integrations\Integrations::IKS) {
		$table = set_prefix($server->db_prefix, 'mutes');
		if(check_table($table, $connection)) {
			$count           = get_rows_count(
				$connection,
				$table,
				"server_id = {$server->integration_server_id} OR server_id = 0"
			);
			$count_active    = get_rows_count(
				$connection,
				$table,
				"Unbanned = 0 AND (end > {$now} OR end = 0) AND (server_id = {$server->integration_server_id} OR server_id = 0)"
			);
			$count_permanent = get_rows_count(
				$connection,
				$table,
				"time = 0 AND (server_id = {$server->integration_server_id} OR server_id = 0)"
			);
			$count_temporal  = get_rows_count(
				$connection,
				$table,
				"time != 0 AND (server_id = {$server->integration_server_id} OR server_id = 0)"
			);
		} else {
			$error = $messages['Not_found_tables'];
		}
	}
}

resetIfPaginationIncorrect($number, $limit, $count, '../muts');

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", page()->title);
$tpl->set("{name}", configs()->name);
$tpl->compile('title');
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title'], false);
$tpl->set("{site_name}", configs()->name);
$tpl->set("{image}", page()->image);
$tpl->set("{robots}", page()->robots);
$tpl->set("{type}", page()->kind);
$tpl->set("{description}", page()->description);
$tpl->set("{keywords}", page()->keywords);
$tpl->set("{url}", page()->full_url);
$tpl->set("{other}", getLibAssets('timepicker'));
$tpl->set("{token}", token());
$tpl->set("{cache}", configs()->cache);
$tpl->set("{template}", get_template());
$tpl->compile('content');
$tpl->clear();

$menu = $tpl->get_menu();

$nav = [
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('muts', 1, 0)
];
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

if(is_auth()) {
	include_once __DIR__ . '/../../inc/authorized.php';
} else {
	include_once __DIR__ . '/../../inc/not_authorized.php';
}

$tpl->result['categories'] = '';

foreach(GameCMS\Repositories\ServerRepository::getAll() as $serverItem) {
	if(!$mutesService->getIntegrator($serverItem->type)->isBlank()) {
		tpl()->compileCategory(
			$serverItem->name,
			'../muts?server=' . $serverItem->id,
			$serverItem->id == $server->id,
			'muts'
		);
	}
}

$tpl->load_template('/home/mutlist.tpl');
$tpl->set("{template}", get_template());
$tpl->set("{start}", $start);
$tpl->set("{limit}", $limit);
$tpl->set("{server}", $server->id);
$tpl->set("{error}", $error);
$tpl->set("{servers}", $tpl->result['categories'], false);
$tpl->set("{count}", $count);
$tpl->set("{count_active}", $count_active);
$tpl->set("{count_permanent}", $count_permanent);
$tpl->set("{count_temporal}", $count_temporal);
$tpl->set("{pagination}", $tpl->paginator($number, $count, $limit, $page_name));
$tpl->compile('content');
$tpl->clear();