<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Тип, описывающий атрибуты счета в системе MONETA.RU.
	 * Information about a MONETA.RU account.
	 * 
 */
class AccountInfo
{
	
	/**
	 * Номер счета в системе MONETA.RU.
	 * MONETA.RU account number.
	 * 
	 *
	 * @var long
	 */
	 public $id = null;

	/**
	 * Валюта данного счета.
	 * Currency of the specified account.
	 * 
	 *
	 * @var string
	 */
	 public $currency = null;

	/**
	 * Баланс на данном счете.
	 * Current balance of account
	 * 
	 *
	 * @var decimal
	 */
	 public $balance = null;

	/**
	 * Доступный баланс на данном счете.
	 * Account balance.
	 * 
	 *
	 * @var decimal
	 */
	 public $availableBalance = null;

	/**
	 * Тип счета в системе MONETA.RU.
	 * MONETA.RU account type.
	 * 
	 *
	 * @var int
	 */
	 public $type = null;

	/**
	 * Статус счета в системе MONETA.RU.
	 * Status of the MONETA.RU account.
	 * 
	 *
	 * @var int
	 */
	 public $status = null;

	/**
	 * Название счета в системе MONETA.RU.
	 * Account alias.
	 * 
	 *
	 * @var string
	 */
	 public $alias = null;

	/**
	 * URL после списания средств.
	 * Specifies the URL of the script that MONETA.RU calls after debiting the payer's account.
	 * 
	 *
	 * @var string
	 */
	 public $onSuccessfulDebitUrl = null;

	/**
	 * URL после зачисления средств.
	 * Specifies the URL of the script that MONETA.RU calls after crediting the payee's account.
	 * 
	 *
	 * @var string
	 */
	 public $onSuccessfulCreditUrl = null;

	/**
	 * Код проверки целостности данных.
	 * Signature that MONETA.RU uses to verify data integrity submitted from a payment form.
	 * 
	 *
	 * @var string
	 */
	 public $signature = null;

	/**
	 * Если баланс счета меньше данного значения, то раз в сутки уходит уведомление об этом событии.
	 * Specifies the minimum balance threshold for an account. If the balance drops below the threshold, MONETA.RU sends daily notifications to the account owner.
	 * 
	 *
	 * @var decimal
	 */
	 public $lowBalanceThreshold = null;

	/**
	 * Если баланс счета больше данного значения, то раз в сутки уходит уведомление об этом событии.
	 * Specifies the maximum balance threshold for an account. If the balance exceeds the threshold, MONETA.RU sends daily notifications to the account owner.
	 * 
	 *
	 * @var decimal
	 */
	 public $highBalanceThreshold = null;

	/**
	 * Информация о доступе к счету. Информация отдается, если счет является делегированным.
	 * Account access information. MONETA.RU provides this information if the account is delegated. If the account is not delegated, this element is omitted.
	 * 
	 *
	 * @var AccountAccessInfo
	 */
	 public $accountAccess = null;

	/**
	 * Счет-прототип с которого берутся свойства "по умолчанию".
	 * Prototype account number. Settings from this account are used as default values.
	 * 
	 *
	 * @var long
	 */
	 public $prototypeAccountId = null;

	/**
	 * URL после отмены списания средств.
	 * Specifies the URL of the script that MONETA.RU calls if a debit transaction is canceled.
	 * 
	 *
	 * @var string
	 */
	 public $onCancelledDebitUrl = null;

	/**
	 * URL после отмены зачисления средств.
	 * Specifies the URL of the script that MONETA.RU calls if a deposit transaction is canceled.
	 * 
	 *
	 * @var string
	 */
	 public $onCancelledCreditUrl = null;

	/**
	 * Дополнительные свойства счета.
	 * Для получения этого поля в запросе необходимо выставлять атрибут version равный или больше VERSION_2.
	 * Возможные ключи:
	 * paymentPasswordType - тип платежного пароля.
	 * STATIC. Статический платежный пароль.
	 * SEQUENCE_BY_ORDER. Последовательность по порядку.
	 * SMS_SIMPLE. SMS пароль.
	 * SMS_SESSION. SMS пароль (сессионный).
	 * TOTP_RFC6238. Time-based one-time password algorithm.
	 * paymentPasswordChallengeRequired. Если в ответе придет поле с ключом key="paymentPasswordChallengeRequired"
	 * и значением value="true", то перед проведением операции следует сделать запрос "GetAccountPaymentPasswordChallengeRequest",
	 * который вернет строку запроса для платежного пароля. Это значение необходимо использовать в поле "paymentPasswordChallenge"
	 * в запросах на проведение операции (например: "PaymentRequest", "TransferRequest", "AuthoriseTransactionRequest" и т.д.).
	 * paymentPasswordExpirationDate. Срок действия платежного пароля. Пример: 2017-01-09T14:11:24.000+03:00.
	 * Это поле возвращается, если на счете установлен "Срок действия платежного пароля" и тип платежного пароля (paymentPasswordType) статический (STATIC).
	 * alias. Название счета. В этом свойстве также можно узнать, является ли название счета "публичным".
	 * primary. Если счет является "Основным", то значение будет равно true.
	 * Возвращается в методе FindAccountsListRequest. В методах FindAccountByIdRequest и FindAccountByAliasRequest это значение не возвращается.
	 * delegated. Если счет является делегированным, то значение будет равно true.
	 * balanceChangesDate. Дата изменения баланса. Пример: 2017-01-09T14:11:24.000+03:00
	 * bankAccountForCredits. Внутрибанковский счет для пополнения.
	 * bankAccountForDebits. Внутрибанковский счет для списания.
	 * interfacetype. Тип интерфейса.
	 * 1 - MONETA.Assistant.
	 * testmode. Тестовый режим (true|false).
	 * paymentsystem_limitids. Список платежных систем.
	 * paymentsystem_unitid. Платежная система по умолчанию.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP метод (PayUrl, CheckUrl).
	 * signature. Код проверки целостности данных.
	 * issignaturemandatory. Подпись формы оплаты обязательна (true|false).
	 * redefinesettingsinurl. Можно переопределять настройки в url (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (возврат для iframe).
	 * onsuccessdebiturl. URL после списания средств.
	 * onsuccesscrediturl. URL после зачисления средств.
	 * oncancelleddebiturl. URL после отмены списания средств.
	 * oncancelledcrediturl. URL после отмены зачисления средств.
	 * onauthoriseurl. URL после авторизации средств.
	 * Additional account attributes.
	 * MONETA.RU returns this element only if you set the version attribute of your request toVERSION_2.
	 * Valid values for the key and value elements:
	 * paymentPasswordType
	 * STATIC. Static payment password.
	 * SEQUENCE_BY_ORDER. Ordered sequence.
	 * SMS_SIMPLE. SMS password.
	 * SMS_SESSION. SMS password (sessional).
	 * TOTP_RFC6238. Time-based one-time password algorithm.
	 * paymentPasswordChallengeRequired. If the response contains an attribute with the key="paymentPasswordChallengeRequired"
	 * and value="true", you must call GetAccountPaymentPasswordChallengeRequest for the payer's account to get the paymentPasswordChallenge element.
	 * This element is used in the following requests: PaymentRequest, TransferRequest, AuthoriseTransactionRequest.
	 * paymentPasswordExpirationDate. Payment password expiration date. Example: 2017-01-09T14:11:24.000+03:00
	 * alias. Account alias.
	 * primary. Value is true, if the account is primary.
	 * Value is used in FindAccountsListRequest method only.
	 * delegated. Value is true, if the account is delegated.
	 * balanceChangesDate. Balance changes. Example: 2017-01-09T14:11:24.000+03:00
	 * bankAccountForCredits. Bank account for credits.
	 * bankAccountForDebits. Bank account for debits.
	 * interfacetype. Interface type.
	 * 1 - MONETA.Assistant.
	 * testmode. Test mode (true|false).
	 * paymentsystem_limitids. Payment method IDs.
	 * paymentsystem_unitid. Default payment method.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP method (PayUrl, CheckUrl).
	 * signature. Code of data integrity verification.
	 * issignaturemandatory. Mandatory payment form signature (true|false).
	 * redefinesettingsinurl. Settings can be redefined in URL (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (redirect in iframe).
	 * onsuccessdebiturl. URL on debiting.
	 * onsuccesscrediturl. URL on crediting.
	 * oncancelleddebiturl. URL on cancelled debit.
	 * oncancelledcrediturl. URL on cancelled credit.
	 * onauthoriseurl. URL on authorising.
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $attribute = null;

	/**
	 * Дополнительные свойства счета.
	 * Для получения этого поля в запросе необходимо выставлять атрибут version равный или больше VERSION_2.
	 * Возможные ключи:
	 * paymentPasswordType - тип платежного пароля.
	 * STATIC. Статический платежный пароль.
	 * SEQUENCE_BY_ORDER. Последовательность по порядку.
	 * SMS_SIMPLE. SMS пароль.
	 * SMS_SESSION. SMS пароль (сессионный).
	 * TOTP_RFC6238. Time-based one-time password algorithm.
	 * paymentPasswordChallengeRequired. Если в ответе придет поле с ключом key="paymentPasswordChallengeRequired"
	 * и значением value="true", то перед проведением операции следует сделать запрос "GetAccountPaymentPasswordChallengeRequest",
	 * который вернет строку запроса для платежного пароля. Это значение необходимо использовать в поле "paymentPasswordChallenge"
	 * в запросах на проведение операции (например: "PaymentRequest", "TransferRequest", "AuthoriseTransactionRequest" и т.д.).
	 * paymentPasswordExpirationDate. Срок действия платежного пароля. Пример: 2017-01-09T14:11:24.000+03:00.
	 * Это поле возвращается, если на счете установлен "Срок действия платежного пароля" и тип платежного пароля (paymentPasswordType) статический (STATIC).
	 * alias. Название счета. В этом свойстве также можно узнать, является ли название счета "публичным".
	 * primary. Если счет является "Основным", то значение будет равно true.
	 * Возвращается в методе FindAccountsListRequest. В методах FindAccountByIdRequest и FindAccountByAliasRequest это значение не возвращается.
	 * delegated. Если счет является делегированным, то значение будет равно true.
	 * balanceChangesDate. Дата изменения баланса. Пример: 2017-01-09T14:11:24.000+03:00
	 * bankAccountForCredits. Внутрибанковский счет для пополнения.
	 * bankAccountForDebits. Внутрибанковский счет для списания.
	 * interfacetype. Тип интерфейса.
	 * 1 - MONETA.Assistant.
	 * testmode. Тестовый режим (true|false).
	 * paymentsystem_limitids. Список платежных систем.
	 * paymentsystem_unitid. Платежная система по умолчанию.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP метод (PayUrl, CheckUrl).
	 * signature. Код проверки целостности данных.
	 * issignaturemandatory. Подпись формы оплаты обязательна (true|false).
	 * redefinesettingsinurl. Можно переопределять настройки в url (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (возврат для iframe).
	 * onsuccessdebiturl. URL после списания средств.
	 * onsuccesscrediturl. URL после зачисления средств.
	 * oncancelleddebiturl. URL после отмены списания средств.
	 * oncancelledcrediturl. URL после отмены зачисления средств.
	 * onauthoriseurl. URL после авторизации средств.
	 * Additional account attributes.
	 * MONETA.RU returns this element only if you set the version attribute of your request toVERSION_2.
	 * Valid values for the key and value elements:
	 * paymentPasswordType
	 * STATIC. Static payment password.
	 * SEQUENCE_BY_ORDER. Ordered sequence.
	 * SMS_SIMPLE. SMS password.
	 * SMS_SESSION. SMS password (sessional).
	 * TOTP_RFC6238. Time-based one-time password algorithm.
	 * paymentPasswordChallengeRequired. If the response contains an attribute with the key="paymentPasswordChallengeRequired"
	 * and value="true", you must call GetAccountPaymentPasswordChallengeRequest for the payer's account to get the paymentPasswordChallenge element.
	 * This element is used in the following requests: PaymentRequest, TransferRequest, AuthoriseTransactionRequest.
	 * paymentPasswordExpirationDate. Payment password expiration date. Example: 2017-01-09T14:11:24.000+03:00
	 * alias. Account alias.
	 * primary. Value is true, if the account is primary.
	 * Value is used in FindAccountsListRequest method only.
	 * delegated. Value is true, if the account is delegated.
	 * balanceChangesDate. Balance changes. Example: 2017-01-09T14:11:24.000+03:00
	 * bankAccountForCredits. Bank account for credits.
	 * bankAccountForDebits. Bank account for debits.
	 * interfacetype. Interface type.
	 * 1 - MONETA.Assistant.
	 * testmode. Test mode (true|false).
	 * paymentsystem_limitids. Payment method IDs.
	 * paymentsystem_unitid. Default payment method.
	 * checkurl. Check URL.
	 * payurl. Pay URL.
	 * httpmethod. HTTP method (PayUrl, CheckUrl).
	 * signature. Code of data integrity verification.
	 * issignaturemandatory. Mandatory payment form signature (true|false).
	 * redefinesettingsinurl. Settings can be redefined in URL (true|false).
	 * successurl. Success URL.
	 * failurl. Fail URL.
	 * inprogressurl. InProgress URL.
	 * returnurl. Return URL.
	 * assistantformtarget. Target (redirect in iframe).
	 * onsuccessdebiturl. URL on debiting.
	 * onsuccesscrediturl. URL on crediting.
	 * oncancelleddebiturl. URL on cancelled debit.
	 * oncancelledcrediturl. URL on cancelled credit.
	 * onauthoriseurl. URL on authorising.
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addAttribute(KeyValueAttribute $item)
	{
		$this->attribute[] = $item;
	}

}
