<?php

// Warning! This code was generated by WSDL2PHP tool. 
// author: Filippov Andrey <afi.work@gmail.com> 
// see https://solo-framework-lib.googlecode.com 

namespace Moneta\Types;

/**
 * Информация об операции.
	 * Operation details.
	 * 
 */
class AccountStatementRecordType
{
	
	/**
	 * Дата операции.
	 * Operation date.
	 * 
	 *
	 * @var dateTime
	 */
	 public $date = null;

	/**
	 * Номер операции в системе MONETA.RU.
	 * MONETA.RU transaction ID.
	 * 
	 *
	 * @var long
	 */
	 public $operationId = null;

	/**
	 * Вид операции.
	 * Operation type.
	 * 
	 *
	 * @var int
	 */
	 public $operationView = null;

	/**
	 * Наименование контрагента.
	 * Correspondent.
	 * 
	 *
	 * @var string
	 */
	 public $correspondentName = null;

	/**
	 * Номер счета контрагента в системе MONETA.RU.
	 * Correspondent account number in MONETA.RU.
	 * 
	 *
	 * @var long
	 */
	 public $correspondentAccountId = null;

	/**
	 * Номер корреспондирующего счета контрагента.
	 * Corresponding account.
	 * 
	 *
	 * @var string
	 */
	 public $correspondentAccount = null;

	/**
	 * Сумма по дебету счета.
	 * Debit amount.
	 * 
	 *
	 * @var decimal
	 */
	 public $debitAmount = null;

	/**
	 * Сумма по кредиту счета.
	 * Credit amount.
	 * 
	 *
	 * @var decimal
	 */
	 public $creditAmount = null;

	/**
	 * ИНН плательщика.
	 * Payer INN.
	 * 
	 *
	 * @var string
	 */
	 public $payerINN = null;

	/**
	 * ИНН получателя платежа.
	 * Payee INN.
	 * 
	 *
	 * @var string
	 */
	 public $payeeINN = null;

	/**
	 * Номер платёжного документа.
	 * The number of payment document.
	 * 
	 *
	 * @var string
	 */
	 public $documentNumber = null;

	/**
	 * БИК.
	 * BIK.
	 * 
	 *
	 * @var string
	 */
	 public $BIK = null;

	/**
	 * Атрибуты операции.
	 * Список возвращаемых атрибутов задан в AccountStatementRequest в поле operationPropertyNames
	 * Operation attributes.
	 * The list of returned attributes is setting in AccountStatementRequest operationPropertyNames.
	 * 
	 *
	 * @var KeyValueAttribute
	 */
	 public $operationAttributes = null;

	/**
	 * Атрибуты операции.
	 * Список возвращаемых атрибутов задан в AccountStatementRequest в поле operationPropertyNames
	 * Operation attributes.
	 * The list of returned attributes is setting in AccountStatementRequest operationPropertyNames.
	 * 
	 *
	 * @param KeyValueAttribute
	 *
	 * @return void
	 */
	public function addOperationAttributes(KeyValueAttribute $item)
	{
		$this->operationAttributes[] = $item;
	}

	/**
	 * Назначение операции.
	 * Operation purpose.
	 * 
	 *
	 * @var string
	 */
	 public $description = null;

}
